#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Bluemindo: A really simple but powerful audio player in Python/PyGTK.
# Copyright (C) 2007-2009  Erwan Briand

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation version 3 of the License.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from os.path import isfile, exists
from gettext import (bindtextdomain, textdomain, bind_textdomain_codeset,
                     gettext as _)

if isfile('../locale/bluemindo.pot'):
    localedir = '../locale'
else:
    localedir = '/usr/share/locale'

bindtextdomain('bluemindo', localedir)
textdomain('bluemindo')
bind_textdomain_codeset('bluemindo', 'UTF-8')

from socket import socket, AF_UNIX, SOCK_DGRAM, error as socket_error
from pickle import dumps
from sys import argv
from os import remove
from os.path import join

from gui.boxes import DialogBox
from common.config import ConfigLoader
from common.functions import Functions

functions = Functions()
config = ConfigLoader()

class Bluemindo(object):
    def __init__(self):
        SOCKET_NAME = '/tmp/bluemindo'

        if len(argv) > 1 and argv[1] in ('-h', '--help'):
            # Show the help
            print _("Bluemindo  Copyright (C) 2007-2009  Erwan Briand\n"
                    "This program comes with ABSOLUTELY NO WARRANTY.\n"
                    "This is free software, and you are welcome to\n"
                    "redistribute it under certain conditions.\n\n"
                    "Usage: bluemindo[.py] [options]\n\n"
                    "Available options:\n"
                    "--current\t\t"
                     "Show the current playing song artist, title and album\n"
                    "--current-cover\t\t"
                     "Show the path to the cover of the current playing song\n"
                    "--current-lyrics\t"
                     "Show the lyrics for the current playing song\n\n"
                    "--playpause, --play, --pause\t"
                     "Play or pause a song\n"
                    "--stop\t\t\t"
                     "Stop a song\n"
                    "--previous\t\t"
                     "Jump to the previous song in playlist\n"
                    "--next\t\t\t"
                     "Jump to the next song in playlist\n\n"
                    "--volume-more [STEP]\t"
                     "Increase the volume, you can specify a step (0 > 100)\n"
                    "--volume-less [STEP]\t"
                     "Decrease the volume, you can specify a step (0 > 100)\n"
                    "--volume=VOLUME\t\t"
                     "Set the volume: 0 > 100\n\n"
                    "--reload\t\t"
                     "Reload the songs from your music folder\n"
                    "--quit, --plunge\t"
                     "Quit Bluemindo")

        elif len(argv) > 1 and argv[1].startswith('--current'):
            # Get the current song
            current_playing = join(config.datadir, 'current-playing')
            if exists(current_playing):
                file_ = open(current_playing)
                csong = file_.read()
                csong_ = csong.split(' (from: ')
                calbum = csong_[1][:-1]

                csong_ = csong_[0].split(' - ')
                cartist = csong_[0]
                ctitle = csong_[1]
                file_.close()

                # Send the current playing song album cover
                if argv[1].endswith('-cover'):
                    file_ = join(config.datadir, 'modules', 'player',
                               functions.get_hash(calbum, cartist) + '.covers')
                    if isfile(file_):
                        print file_
                    else:
                        print 'File not found.'

                # Send the current playing song lyrics                
                elif argv[1].endswith('-lyrics'):
                    file_ = join(config.datadir, 'modules', 'lyrics',
                            functions.get_hash(ctitle, cartist) + '.lyrics')
                    if isfile(file_):
                        lyric = open(file_)
                        print lyric.read()
                        lyric.close()
                    else:
                        print 'File not found.'

                # Send the current playing song artist and title
                else:
                    print csong

        elif len(argv) > 1 and exists(SOCKET_NAME):
            # Create a client and connect to the UNIX socket in
            # order to send the user's request
            try:
                client = socket(AF_UNIX, SOCK_DGRAM)
                client.connect_ex(SOCKET_NAME)
                client.send(dumps(argv))
                client.close()
            except socket_error:
                print 'Socket error.'

        elif len(argv) > 1 and not exists(SOCKET_NAME):
            # We cannot do anything here
            print 'Socket not found.'

        elif len(argv) == 1 and exists(SOCKET_NAME):
            # The socket exists but we want to start Bluemindo: it fails
            db = DialogBox(title=_('Bluemindo is already started!'),
                           text=_('The socket file located at '
                                '<i>/tmp/bluemindo</i> already exists, so '
                                'Bluemindo cannot start. If you still want '
                                'to start Bluemindo, hit "yes" but part of '
                                'the software might be broken.'))

            if db.get_answer() == 0:
                # Remove the existing socket
                remove(SOCKET_NAME)
                if isfile(join(config.datadir, 'lock')):
                    remove(join(config.datadir, 'lock'))

                # Yes I know it's not pretty to do an import here but pygst
                # is doing crazy things with --help and I'm tired of that. :'(
                from mainapplication import MainApplication
                MainApplication()

        else:
            # Start Bluemindo
            if isfile(join(config.datadir, 'lock')):
                remove(join(config.datadir, 'lock'))

            # Yes I know it's not pretty to do an import here but pygst
            # is doing crazy things with --help and I'm tired of that. :'(
            from mainapplication import MainApplication

            # Launch Bluemindo
            MainApplication()

def main():
    bluemindo = Bluemindo()
   
if __name__ == "__main__":
    main()