/*
 * Decompiled with CFR 0.152.
 */
package yuku.alkitabconverter.unboundbible;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import yuku.alkitabconverter.util.Rec;

public class UnboundBibleReader {
    public static List<Rec> parse(String nf, int kolom_orig_book_index, int kolom_pasal_1, int kolom_ayat_1, int kolom_isi) throws Exception {
        LinkedHashMap<Integer, Integer> nn = new LinkedHashMap<Integer, Integer>();
        ArrayList<Rec> res = new ArrayList<Rec>();
        Scanner sc = new Scanner(new File(nf), "utf-8");
        int lastKitab_1 = 1;
        int lastPasal_1 = 1;
        int lastAyat_1 = 0;
        while (sc.hasNextLine()) {
            String baris = sc.nextLine();
            if (baris.startsWith("#") || baris.trim().length() == 0) continue;
            String[] xkolom = baris.split("\t", -1);
            if (xkolom.length != kolom_isi + 1) {
                throw new RuntimeException("baris ngaco: " + baris);
            }
            String orig_book_index = xkolom[kolom_orig_book_index];
            int pasal_1 = Integer.parseInt(xkolom[kolom_pasal_1]);
            int ayat_1 = Integer.parseInt(xkolom[kolom_ayat_1]);
            String isi = xkolom[kolom_isi];
            int kitab_1 = UnboundBibleReader.ubToKitab1(orig_book_index);
            if (ayat_1 != lastAyat_1 + 1 && pasal_1 != lastPasal_1 + 1 && pasal_1 != 1) {
                throw new RuntimeException("urutan ngaco: " + baris);
            }
            nn.put(kitab_1, (nn.get(kitab_1) == null ? 0 : (Integer)nn.get(kitab_1)) + 1);
            Rec rec = new Rec();
            rec.book_1 = kitab_1;
            rec.chapter_1 = pasal_1;
            rec.verse_1 = ayat_1;
            rec.text = isi;
            res.add(rec);
            lastKitab_1 = kitab_1;
            lastPasal_1 = pasal_1;
            lastAyat_1 = ayat_1;
        }
        for (Map.Entry e : nn.entrySet()) {
            System.out.println(e.getKey() + ": " + e.getValue());
        }
        System.out.println("selesai. Total rec: " + res.size());
        return res;
    }

    private static int ubToKitab1(String ub) {
        if (ub.matches("[0-9][0-9](O|N)")) {
            return Integer.parseInt(ub.substring(0, 2));
        }
        if (ub.matches("[0-9][0-9]A")) {
            int n = Integer.parseInt(ub.substring(0, 2));
            int[] v = new int[]{68, 69, 85, 76, 77, 80, 79, 82, 81, 83, 70, 71, 72, 73, 66, 67, 84, 86, 78, 75};
            int idx = n - 67;
            if (idx >= 0 && idx < v.length) {
                return v[idx] + 1;
            }
            throw new RuntimeException("ub belum dikenal: " + ub);
        }
        throw new RuntimeException("ub belum dikenal: " + ub);
    }
}

