#!/bin/sh

set -e

PACKAGE=$1

if [ -d ../build ]; then
    cd ..
fi

. ben/env.sh

cd build

CHANGES="$(find -name "$PACKAGE"'_*.changes')"
LOG_LINK="$(find -name "$PACKAGE"'_*'"$ARCH"'.build')"

if [ -L "$LOG_LINK" ]; then
    LOG="$(readlink "$LOG_LINK")"
    if [ -f "$LOG" ]; then
        mv "$LOG_LINK" "$LOG" ../pool
    fi
fi

if [ -f "$CHANGES" ] && [ "$(dcmd "$CHANGES" | grep '\.deb$' | wc -l)" -ge 1 ]; then
    dcmd mv "$CHANGES" ../pool
fi
