#!/bin/sh

PACKAGE=$1

cd ..

has_debs () {
    [ -f "$1" ] && [ "$(dcmd "$1" | grep '\.deb$' | wc -l)" -ge 1 ]
}

if [ -f pool/$PACKAGE.fake ]; then
    if [ -f pool/$PACKAGE.reason ]; then
        # The package fails for a known reason, report failure
        exit 2
    else
        # Assume the package exists in the new universe, report success
        exit 0
    fi
fi

if has_debs pool/${PACKAGE}_*.changes; then
    # The package exists in the new universe, report success
    exit 0
elif [ "$(find pool -name "${PACKAGE}_*.build" | wc -l)" -ge 1 ]; then
    # A log already exists, do not retry to build
    exit 2
else
    # Package status unknown, try to build it
    exit 1
fi
