CMAKE_MINIMUM_REQUIRED(VERSION 3.7.1)

FUNCTION(READ_REVISION _var _regex _file)
	IF(EXISTS "${_file}")
		FILE(READ "${_file}" content)
		STRING(REGEX MATCH "${_regex}" _unused "${content}")
		SET(${_var} ${CMAKE_MATCH_1} PARENT_SCOPE)
	ENDIF()
ENDFUNCTION()

IF(NOT CMAKE_ANDROID_NDK)
	SET(CMAKE_ANDROID_NDK $ENV{ANDROID_NDK})
ENDIF()

SET(ANDROID_SDK $ENV{ANDROID_HOME})
SET(ANDROID_BUILD_TOOLS_REVISION $ENV{ANDROID_BUILD_TOOLS_REVISION})

IF(NOT EXISTS "${ANDROID_SDK}")
	MESSAGE(FATAL_ERROR "Environment variable ANDROID_HOME is undefined")
ENDIF()

IF(NOT ANDROID_BUILD_TOOLS_REVISION)
	SET(_android_build_tools_dir "${ANDROID_SDK}/build-tools")

	FILE(GLOB build_tools_list ${_android_build_tools_dir}/*)
	LIST(LENGTH build_tools_list build_tools_len)
	IF(build_tools_len GREATER 0)
		LIST(SORT build_tools_list)
		LIST(GET build_tools_list -1 build_tools)
	ENDIF()

	IF(NOT build_tools)
		MESSAGE(FATAL_ERROR "Cannot determine ANDROID_BUILD_TOOLS_REVISION: ${_android_build_tools_dir}")
	ENDIF()

	GET_FILENAME_COMPONENT(ANDROID_BUILD_TOOLS_REVISION "${build_tools}" NAME)
ENDIF()

READ_REVISION(ANDROID_NDK_REVISION ".*Revision = ([0-9|\\.]+)" "${CMAKE_ANDROID_NDK}/source.properties")
READ_REVISION(ANDROID_SDK_REVISION ".*Revision=([0-9|\\.]+)" "${ANDROID_SDK}/tools/source.properties")

IF(NOT CMAKE_ANDROID_NDK_TOOLCHAIN_VERSION AND ANDROID_NDK_REVISION VERSION_GREATER_EQUAL "11")
	SET(CMAKE_ANDROID_NDK_TOOLCHAIN_VERSION clang)
ENDIF()
SET(ANDROID_NDK_TOOLCHAIN_VERSION 4.9)

SET(CMAKE_SYSTEM_NAME Android)
SET(CMAKE_SYSTEM_VERSION 21)

IF(CMAKE_ANDROID_NDK_TOOLCHAIN_VERSION MATCHES "clang")
	SET(CMAKE_ANDROID_STL_TYPE c++_shared)
ELSE()
	SET(CMAKE_ANDROID_STL_TYPE gnustl_shared)
ENDIF()

IF(NOT CMAKE_ANDROID_ARCH_ABI)
	SET(CMAKE_ANDROID_ARCH_ABI armeabi-v7a)
ENDIF()


SET(CMAKE_FIND_ROOT_PATH ${CMAKE_PREFIX_PATH} CACHE STRING "android find search path root")
SET(CMAKE_FIND_ROOT_PATH_MODE_LIBRARY ONLY)
SET(CMAKE_FIND_ROOT_PATH_MODE_INCLUDE ONLY)
SET(CMAKE_FIND_ROOT_PATH_MODE_PACKAGE ONLY)
