/*
 * Copyright (C) 2009  Genome Research Limited
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
package uk.ac.sanger.artemis.circular.digest;

import static org.junit.Assert.*;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.junit.Ignore;
import org.junit.Test;

import uk.ac.sanger.artemis.circular.digest.CutSite;

public class UtilsTest
{
  /**
   * Test that restrict output is parsed
   */
  @Ignore("Use EmbossTableParserTest")
  @Test
  public void testFindCutSitesFromEmbossReport()
  {
    final InputStream inputStream = UtilsTest.class
        .getResourceAsStream("/data/foo.restrict");

    InputStreamReader reader = new InputStreamReader(inputStream);
    ReportDetails report = Utils.findCutSitesFromEmbossReport(reader);

    assertNotNull("ReportDetails null", report);
    assertEquals("Sequence length", report.length, 41243);

    List<CutSite> cutSites = report.cutSites;
    CutSite firstCutSite = cutSites.get(0);

    assertEquals("Number of cut sites", cutSites.size(), 4);
    assertEquals("Enzyme name", firstCutSite.getEnzymeName(), "HindIII");
    assertEquals("3prime", firstCutSite.getThreePrime(), 85);
    assertEquals("5prime", firstCutSite.getFivePrime(), 81);
    assertEquals("3prime-rev", firstCutSite.getThreePrimeRev(), 0);
    assertEquals("5prime-rev", firstCutSite.getFivePrimeRev(), 0);
    assertTrue("Cut site strand", firstCutSite.isForward());
  }

}
