/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.annotationprocessor;

import android.databinding.BindingBuildInfo;
import android.databinding.annotationprocessor.ProcessBindable;
import android.databinding.annotationprocessor.ProcessDataBinding;
import android.databinding.tool.CompilerChef;
import android.databinding.tool.reflection.SdkUtil;
import android.databinding.tool.store.ResourceBundle;
import android.databinding.tool.util.GenerationalClassUtil;
import android.databinding.tool.util.L;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class ProcessExpressions
extends ProcessDataBinding.ProcessingStep {
    private static final String LAYOUT_INFO_FILE_SUFFIX = "-layoutinfo.bin";
    private final ProcessBindable mProcessBindable;

    public ProcessExpressions(ProcessBindable processBindable) {
        this.mProcessBindable = processBindable;
    }

    @Override
    public boolean onHandleStep(RoundEnvironment roundEnvironment, ProcessingEnvironment processingEnvironment, BindingBuildInfo buildInfo) {
        SdkUtil.initialize(buildInfo.minSdk(), new File(buildInfo.sdkRoot()));
        ResourceBundle resourceBundle = new ResourceBundle(buildInfo.modulePackage());
        List<Intermediate> intermediateList = GenerationalClassUtil.loadObjects(this.getClass().getClassLoader(), new GenerationalClassUtil.ExtensionFilter(LAYOUT_INFO_FILE_SUFFIX));
        IntermediateV1 mine = this.createIntermediateFromLayouts(buildInfo.layoutInfoDir());
        if (mine != null) {
            mine.removeOverridden(intermediateList);
            intermediateList.add(mine);
            this.saveIntermediate(processingEnvironment, buildInfo, mine);
        }
        try {
            this.generateBinders(resourceBundle, buildInfo, intermediateList);
        }
        catch (Throwable t) {
            L.e(t, "cannot generate view binders", new Object[0]);
        }
        return true;
    }

    private void saveIntermediate(ProcessingEnvironment processingEnvironment, BindingBuildInfo buildInfo, IntermediateV1 intermediate) {
        GenerationalClassUtil.writeIntermediateFile(processingEnvironment, buildInfo.modulePackage(), buildInfo.modulePackage() + LAYOUT_INFO_FILE_SUFFIX, intermediate);
    }

    @Override
    public void onProcessingOver(RoundEnvironment roundEnvironment, ProcessingEnvironment processingEnvironment, BindingBuildInfo buildInfo) {
    }

    private void generateBinders(ResourceBundle resourceBundle, BindingBuildInfo buildInfo, List<Intermediate> intermediates) throws Throwable {
        for (Intermediate intermediate : intermediates) {
            intermediate.appendTo(resourceBundle);
        }
        this.writeResourceBundle(resourceBundle, buildInfo.isLibrary(), buildInfo.minSdk());
    }

    private IntermediateV1 createIntermediateFromLayouts(String layoutInfoFolderPath) {
        File layoutInfoFolder = new File(layoutInfoFolderPath);
        if (!layoutInfoFolder.isDirectory()) {
            L.d("layout info folder does not exist, skipping for %s", layoutInfoFolderPath);
            return null;
        }
        IntermediateV1 result = new IntermediateV1();
        for (File layoutFile : layoutInfoFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        })) {
            try {
                result.addEntry(layoutFile.getName(), FileUtils.readFileToString(layoutFile));
            }
            catch (IOException e) {
                L.e(e, "cannot load layout file information. Try a clean build", new Object[0]);
            }
        }
        return result;
    }

    private void writeResourceBundle(ResourceBundle resourceBundle, boolean forLibraryModule, int minSdk) throws JAXBException {
        CompilerChef compilerChef = CompilerChef.createChef(resourceBundle, this.getWriter());
        if (compilerChef.hasAnythingToGenerate()) {
            compilerChef.addBRVariables(this.mProcessBindable);
            compilerChef.writeViewBinderInterfaces(forLibraryModule);
            if (!forLibraryModule) {
                compilerChef.writeViewBinders(minSdk);
            }
        }
        if (!forLibraryModule) {
            compilerChef.writeDbrFile(minSdk);
        }
    }

    public static class IntermediateV1
    implements Intermediate {
        transient Unmarshaller mUnmarshaller;
        Map<String, String> mLayoutInfoMap = new HashMap<String, String>();

        @Override
        public Intermediate upgrade() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void appendTo(ResourceBundle resourceBundle) throws JAXBException {
            if (this.mUnmarshaller == null) {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ResourceBundle.LayoutFileBundle.class});
                this.mUnmarshaller = context.createUnmarshaller();
            }
            for (String content : this.mLayoutInfoMap.values()) {
                InputStream is = IOUtils.toInputStream(content);
                try {
                    ResourceBundle.LayoutFileBundle bundle = (ResourceBundle.LayoutFileBundle)this.mUnmarshaller.unmarshal(is);
                    resourceBundle.addLayoutBundle(bundle);
                    L.d("loaded layout info file %s", bundle);
                }
                finally {
                    IOUtils.closeQuietly(is);
                }
            }
        }

        public void addEntry(String name, String contents) {
            this.mLayoutInfoMap.put(name, contents);
        }

        public void removeOverridden(List<Intermediate> existing) {
            for (Intermediate old : existing) {
                if (!(old instanceof IntermediateV1)) continue;
                IntermediateV1 other = (IntermediateV1)old;
                for (String key : other.mLayoutInfoMap.keySet()) {
                    if (this.mLayoutInfoMap.remove(key) == null) continue;
                    L.d("removing %s from bundle because it came from another module", key);
                }
            }
        }
    }

    public static interface Intermediate
    extends Serializable {
        public Intermediate upgrade();

        public void appendTo(ResourceBundle var1) throws Throwable;
    }
}

