/* libunwind - a platform-independent unwind library
   Copyright (C) 2006-2007 IBM
   Contributed by
     Corey Ashford <cjashfor@us.ibm.com>
     Jose Flavio Aguilar Paulino <jflavio@br.ibm.com> <joseflavio@gmail.com>

This file is part of libunwind.

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.  */

#ifndef unwind_i_h
#define unwind_i_h

#include <stdint.h>

#include <libunwind-ppc64.h>

#include <libunwind_i.h>
#include <sys/ucontext.h>

#define ppc64_lock			UNW_OBJ(lock)
#define ppc64_local_resume		UNW_OBJ(local_resume)
#define ppc64_local_addr_space_init	UNW_OBJ(local_addr_space_init)
#if 0
#define ppc64_scratch_loc		UNW_OBJ(scratch_loc)
#endif

extern void ppc64_local_addr_space_init (void);
extern int ppc64_local_resume (unw_addr_space_t as, unw_cursor_t *cursor,
			     void *arg);
#if 0
extern dwarf_loc_t ppc64_scratch_loc (struct cursor *c, unw_regnum_t reg);
#endif

#endif /* unwind_i_h */
