#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include "main.h"

void
on_load_settings_ok_but_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkEntry *text = GTK_ENTRY(lookup_widget (GTK_WIDGET (window1), "load_file_name_text"));

    gtk_entry_set_text(text, gtk_file_selection_get_filename (GTK_FILE_SELECTION (load_settings_dlg)));
    
    // closes the file selection dialog
    gtk_widget_destroy(load_settings_dlg);

}



void
on_load_settings_filesel_but_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkEntry *text;
    load_settings_dlg = create_load_settings_dlg();
    text = GTK_ENTRY(lookup_widget(GTK_WIDGET(window1), "load_file_name_text"));
    gtk_file_selection_set_filename(GTK_FILE_SELECTION(load_settings_dlg), gtk_entry_get_text(text));
    gtk_widget_show(load_settings_dlg);

}


void
on_save_settings_filesel_but_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkEntry *text;
    save_settings_dlg = create_save_settings_dlg();
    text = GTK_ENTRY(lookup_widget(GTK_WIDGET(window1), "save_file_name_text"));
    gtk_file_selection_set_filename(GTK_FILE_SELECTION(save_settings_dlg), gtk_entry_get_text(text));
    gtk_widget_show(save_settings_dlg);
}


void
on_load_settings_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
    int ret=0;
    const char *s;
    GtkEntry *text = GTK_ENTRY(lookup_widget (GTK_WIDGET (window1), "load_file_name_text"));
    char *b;
    s = gtk_entry_get_text(text);
    b = malloc (strlen(s)+strlen(getenv("HOME"))+2);


    if (s && *s) {
	if (s[0] == '~') {
	    sprintf(b, "%s%s", getenv("HOME"), s+1);
	    ret = read_config_file(&xcfg, b, 1);
	} else {
	    ret = read_config_file(&xcfg, (char *)s, 1);
	}

    }

    if (!ret) {
	GtkWidget *dialog = gtk_message_dialog_new(GTK_WINDOW(window1),
		GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE,
		"Cannot read config from '%s': %s", s, "Syntax error");
	gtk_dialog_run (GTK_DIALOG (dialog));
	gtk_widget_destroy (dialog);
    } else {
	xvidcfg2window();
    }

    free(b);

}


void
on_save_settings_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
    int ret;
    GtkEntry *text = GTK_ENTRY(lookup_widget (GTK_WIDGET (window1), "save_file_name_text"));
    char *b;
    const char *s =  gtk_entry_get_text(text);

    b = malloc (strlen(s)+strlen(getenv("HOME"))+2);

    window2xvidcfg();

    if (s && *s) {
	if (s[0] == '~') {
	    sprintf(b, "%s%s", getenv("HOME"), s+1);
	    ret = read_config_file(&xcfg, b, 0);
	} else {
	    ret = read_config_file(&xcfg, (char *)s, 0);
	}

    }

    if (!ret) {
	GtkWidget *dialog = gtk_message_dialog_new(GTK_WINDOW(window1),
		GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE,
		"Cannot save config to '%s'", s);
	gtk_dialog_run (GTK_DIALOG (dialog));
	gtk_widget_destroy (dialog);
    }


}


void
on_restore_defaults_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
    memcpy (&xcfg, &xcfg_sav, sizeof xcfg );
    xvidcfg2window();
}


void
on_save_defaults_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
    window2xvidcfg();
    memcpy (&xcfg_sav, &xcfg, sizeof xcfg );

}


void
on_save_settings_dlg_ok_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkEntry *text = GTK_ENTRY(lookup_widget (GTK_WIDGET (window1), "save_file_name_text"));

    gtk_entry_set_text(text, gtk_file_selection_get_filename (GTK_FILE_SELECTION (save_settings_dlg)));
    
    // closes the file selection dialog
    gtk_widget_destroy(save_settings_dlg);


}


void
on_matrix_editor_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{

  window2 = create_matrix_edit_dlg(); 
  gtk_widget_show (window2);
}



void
on_save_matrix_edit_but_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
    int matrix[64];
    int i;
    const char *s;
    FILE *f;
    GtkEntry *text = GTK_ENTRY(lookup_widget (GTK_WIDGET (window2), "matrix_edit_file"));
    s = gtk_entry_get_text(text);

    window2matrix(matrix);

    if (s && *s) {
	if ((f = fopen (s, "w")) == NULL) {
	    GtkWidget *dialog = gtk_message_dialog_new(GTK_WINDOW(window2),
		    GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE,
		    "Cannot write to '%s': %s", s, g_strerror (errno));
	    gtk_dialog_run (GTK_DIALOG (dialog));
	    gtk_widget_destroy (dialog);
	} else {
	    for (i=1; i<65; i++) {
		fprintf (f, "%3d ", matrix[i-1]);
		if ((i%8) == 0)
		    fprintf(f, "\n");
	    }
	}
	if (f) fclose(f);
    } else {
	GtkWidget *dialog = gtk_message_dialog_new(GTK_WINDOW(window2),
		GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE,
		"You must enter a filename to save to");
	gtk_dialog_run (GTK_DIALOG (dialog));
	gtk_widget_destroy (dialog);
    }
}


void
on_load_matrix_edit_but_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
    int matrix[64];
    int ret=1;
    const char *s;
    GtkEntry *text = GTK_ENTRY(lookup_widget (GTK_WIDGET (window2), "matrix_edit_file"));
    s = gtk_entry_get_text(text);

    if (s && *s)
	ret = read_matrix(matrix, s);

    if (ret == 1) {
	GtkWidget *dialog = gtk_message_dialog_new(GTK_WINDOW(window2),
		GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE,
		"Cannot read '%s': %s", s, "No such file");
	gtk_dialog_run (GTK_DIALOG (dialog));
	gtk_widget_destroy (dialog);
    } else if (ret == 2) {
	GtkWidget *dialog = gtk_message_dialog_new(GTK_WINDOW(window2),
		GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE,
		"Error while reading matrix file '%s': Syntax error", s);
	gtk_dialog_run (GTK_DIALOG (dialog));
	gtk_widget_destroy (dialog);
    } else 
	matrix2window(matrix);

}


void
on_matrix_edit_ok_but_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkEntry *text = GTK_ENTRY(lookup_widget (GTK_WIDGET (window2), "matrix_edit_file"));

    gtk_entry_set_text(text, gtk_file_selection_get_filename (GTK_FILE_SELECTION (matrix_edit_filsel_dlg)));
    
    // closes the file selection dialog
    gtk_widget_destroy(matrix_edit_filsel_dlg);

}


void
on_open_matrix_file_dlg_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
    const char *s;
    GtkEntry *text = GTK_ENTRY(lookup_widget (GTK_WIDGET (window2), "matrix_edit_file"));
    s = gtk_entry_get_text(text);

    matrix_edit_filsel_dlg = create_matrix_edit_filsel_dlg();

    if (s && *s)
	gtk_file_selection_set_filename(GTK_FILE_SELECTION(matrix_edit_filsel_dlg), gtk_entry_get_text(text));


    gtk_widget_show(matrix_edit_filsel_dlg);

}


void
on_clear_matrix_but_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget *c;
    char field[128];
    int i, j, x;

    x = 0;

    for (j = 0; j<8; j++) {
	for (i = 0; i<8; i++) {
	    sprintf(field, "a%d%d", i, j);
	    c = lookup_widget(GTK_WIDGET(window2), field);
	    gtk_entry_set_text(GTK_ENTRY(c), "");
	}
    }



}


void
on_load_intra_matrix_file_but_clicked  (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkEntry *text;
    const char *s;
    quant_intra_matrix_dlg = create_quant_intra_matrix_dlg();
    text = GTK_ENTRY(lookup_widget (GTK_WIDGET (window1), "quant_intra_matrix"));
    s = gtk_entry_get_text(text);
    if (s && *s) {
	gtk_file_selection_set_filename(GTK_FILE_SELECTION(quant_intra_matrix_dlg), gtk_entry_get_text(text));
    }
    gtk_widget_show(quant_intra_matrix_dlg);

}


void
on_load_inter_matrix_file_but_clicked  (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkEntry *text;
    const char *s;
    quant_inter_matrix_dlg = create_quant_inter_matrix_dlg();
    text = GTK_ENTRY(lookup_widget (GTK_WIDGET (window1), "quant_inter_matrix"));
    s = gtk_entry_get_text(text);
    if (s && *s) {
	gtk_file_selection_set_filename(GTK_FILE_SELECTION(quant_inter_matrix_dlg), gtk_entry_get_text(text));
    }
    gtk_widget_show(quant_inter_matrix_dlg);

}


void
on_quant_intra_matrix_ok_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkEntry *text = GTK_ENTRY(lookup_widget (GTK_WIDGET (window1), "quant_intra_matrix"));

    gtk_entry_set_text(text, gtk_file_selection_get_filename (GTK_FILE_SELECTION (quant_intra_matrix_dlg)));
    gtk_widget_destroy(quant_intra_matrix_dlg);


}


void
on_quant_inter_matrix_ok_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkEntry *text = GTK_ENTRY(lookup_widget (GTK_WIDGET (window1), "quant_inter_matrix"));

    gtk_entry_set_text(text, gtk_file_selection_get_filename (GTK_FILE_SELECTION (quant_inter_matrix_dlg)));
    gtk_widget_destroy(quant_inter_matrix_dlg);


}


void
on_max_bframes_value_changed           (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
    static int is_enabled = 0;
    GtkWidget *c;
    int val;


    c = lookup_widget(GTK_WIDGET(window1), "max_bframes");
    val = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(c));
    if (val>0 && !is_enabled) {
	is_enabled = 1;

	c = lookup_widget(GTK_WIDGET(window1), "bquant_ratio_label"); gtk_widget_set_sensitive (c, TRUE);
	c = lookup_widget(GTK_WIDGET(window1), "bquant_offset_label"); gtk_widget_set_sensitive (c, TRUE);
	c = lookup_widget(GTK_WIDGET(window1), "bframe_threshold_label"); gtk_widget_set_sensitive (c, TRUE);

	c = lookup_widget(GTK_WIDGET(window1), "bquant_ratio"); gtk_widget_set_sensitive (c, TRUE);
	c = lookup_widget(GTK_WIDGET(window1), "bquant_offset"); gtk_widget_set_sensitive (c, TRUE);
	c = lookup_widget(GTK_WIDGET(window1), "bframe_threshold"); gtk_widget_set_sensitive (c, TRUE);

	c = lookup_widget(GTK_WIDGET(window1), "closed_gop"); gtk_widget_set_sensitive (c, TRUE);
	c = lookup_widget(GTK_WIDGET(window1), "packed"); gtk_widget_set_sensitive (c, TRUE);

	c = lookup_widget(GTK_WIDGET(window1), "bquant_min_max_label");  gtk_widget_set_sensitive (c, TRUE);
	c = lookup_widget(GTK_WIDGET(window1), "min_bquant");  gtk_widget_set_sensitive (c, TRUE);
	c = lookup_widget(GTK_WIDGET(window1), "max_bquant");  gtk_widget_set_sensitive (c, TRUE);


	/*
	c = lookup_widget(GTK_WIDGET(window1), "quarterpel"); gtk_widget_set_sensitive (c, TRUE);
	c = lookup_widget(GTK_WIDGET(window1), "gmc"); gtk_widget_set_sensitive (c, TRUE);
	*/
    } else if (val == 0) {
	is_enabled = 0;

	c = lookup_widget(GTK_WIDGET(window1), "bquant_ratio_label"); gtk_widget_set_sensitive (c, FALSE);
	c = lookup_widget(GTK_WIDGET(window1), "bquant_offset_label"); gtk_widget_set_sensitive (c, FALSE);
	c = lookup_widget(GTK_WIDGET(window1), "bframe_threshold_label"); gtk_widget_set_sensitive (c, FALSE);

	c = lookup_widget(GTK_WIDGET(window1), "bquant_ratio"); gtk_widget_set_sensitive (c, FALSE);
	c = lookup_widget(GTK_WIDGET(window1), "bquant_offset"); gtk_widget_set_sensitive (c, FALSE);
	c = lookup_widget(GTK_WIDGET(window1), "bframe_threshold"); gtk_widget_set_sensitive (c, FALSE);

	c = lookup_widget(GTK_WIDGET(window1), "packed"); gtk_widget_set_sensitive (c, FALSE);
	c = lookup_widget(GTK_WIDGET(window1), "closed_gop"); gtk_widget_set_sensitive (c, FALSE);

	c = lookup_widget(GTK_WIDGET(window1), "bquant_min_max_label");  gtk_widget_set_sensitive (c, FALSE);
	c = lookup_widget(GTK_WIDGET(window1), "min_bquant");  gtk_widget_set_sensitive (c, FALSE);
	c = lookup_widget(GTK_WIDGET(window1), "max_bquant");  gtk_widget_set_sensitive (c, FALSE);

	/*
	c = lookup_widget(GTK_WIDGET(window1), "quarterpel"); gtk_widget_set_sensitive (c, FALSE);
	c = lookup_widget(GTK_WIDGET(window1), "gmc"); gtk_widget_set_sensitive (c, FALSE);
	*/

    }


}


gboolean
on_window1_delete_event                (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  if (ofile) {
    int ret;
    GtkEntry *text = GTK_ENTRY(lookup_widget (GTK_WIDGET (window1), "save_file_name_text"));
    const char *s =  gtk_entry_get_text(text);

    window2xvidcfg();
    //read_config_file(&xcfg, NULL, 0);
    ret = read_config_file(&xcfg, (char *)s, 0);

    if (!ret) {
	GtkWidget *dialog = gtk_message_dialog_new(GTK_WINDOW(window1),
		GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE,
		"Cannot save config to '%s'", s);
	gtk_dialog_run (GTK_DIALOG (dialog));
	gtk_widget_destroy (dialog);
    }
  }
  gtk_main_quit();

  return FALSE;
}

void
on_quit_delete_event                   (GtkButton       *button,
                                        gpointer         user_data)
{
  if (ofile) {
    int ret;
    GtkEntry *text = GTK_ENTRY(lookup_widget (GTK_WIDGET (window1), "save_file_name_text"));
    const char *s =  gtk_entry_get_text(text);

    window2xvidcfg();
    //read_config_file(&xcfg, NULL, 0);
    ret = read_config_file(&xcfg, (char *)s, 0);

    if (!ret) {
	GtkWidget *dialog = gtk_message_dialog_new(GTK_WINDOW(window1),
		GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE,
		"Cannot save config to '%s'", s);
	gtk_dialog_run (GTK_DIALOG (dialog));
	gtk_widget_destroy (dialog);
    }
  }

  gtk_main_quit();

}

