/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.client.sei;

import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.client.RequestContext;
import com.sun.xml.ws.client.ResponseContextReceiver;
import com.sun.xml.ws.client.sei.ResponseBuilder;
import com.sun.xml.ws.client.sei.SEIMethodHandler;
import com.sun.xml.ws.client.sei.SEIStub;
import com.sun.xml.ws.client.sei.ValueGetterFactory;
import com.sun.xml.ws.client.sei.ValueSetterFactory;
import com.sun.xml.ws.encoding.soap.DeserializationException;
import com.sun.xml.ws.fault.SOAPFaultBuilder;
import com.sun.xml.ws.model.JavaMethodImpl;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;

final class SyncMethodHandler
extends SEIMethodHandler {
    private final ResponseBuilder responseBuilder;

    SyncMethodHandler(SEIStub owner, JavaMethodImpl method) {
        super(owner, method);
        this.responseBuilder = this.buildResponseBuilder(method, ValueSetterFactory.SYNC);
    }

    Object invoke(Object proxy, Object[] args) throws Throwable {
        return this.invoke(proxy, args, this.owner.requestContext, this.owner);
    }

    Object invoke(Object proxy, Object[] args, RequestContext rc, ResponseContextReceiver receiver) throws Throwable {
        Packet req = new Packet(this.createRequestMessage(args));
        req.soapAction = this.soapAction;
        req.expectReply = !this.isOneWay;
        req.getMessage().assertOneWay(this.isOneWay);
        Packet reply = this.owner.doProcess(req, rc, receiver);
        Message msg = reply.getMessage();
        if (msg == null) {
            return null;
        }
        try {
            if (msg.isFault()) {
                SOAPFaultBuilder faultBuilder = SOAPFaultBuilder.create(msg);
                throw faultBuilder.createException(this.checkedExceptions);
            }
            return this.responseBuilder.readResponse(msg, args);
        }
        catch (JAXBException e) {
            throw new DeserializationException("failed.to.read.response", new Object[]{e});
        }
        catch (XMLStreamException e) {
            throw new DeserializationException("failed.to.read.response", new Object[]{e});
        }
    }

    ValueGetterFactory getValueGetterFactory() {
        return ValueGetterFactory.SYNC;
    }
}

