# Keep compatibility with 2.20 and older

archives_return_list_legacy() {
	local variable_name_pattern
	variable_name_pattern='^ARCHIVE_[0-9A-Z]\+\(_OLD[0-9A-Z]*\)*='
	set | \
		grep --regexp="$variable_name_pattern" | \
		cut --delimiter='=' --fields=1
}

current_archive_suffix_legacy() {
	local archive
	archive=$(current_archive)

	if \
		compatibility_level_is_at_least '2.13' && \
		[ "${archive#ARCHIVE_BASE}" != "$archive" ]
	then
		printf '%s' "${archive#ARCHIVE_BASE}"
	else
		printf '%s' "${archive#ARCHIVE}"
	fi
}

