#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Stellaris expansions (species packs):
# - Plantoids
# - Humanoids
# - Lithoids
# - Necroids
# - Aquatics
# - Toxoids
###

script_version=20240620.1

PLAYIT_COMPATIBILITY_LEVEL='2.29'

GAME_ID='stellaris'
GAME_NAME='Stellaris'

EXPANSION_ID_PLANTOID='plantoid'
EXPANSION_NAME_PLANTOID='Plantoids Species Pack'

EXPANSION_ID_HUMANOIDS='humanoids'
EXPANSION_NAME_HUMANOIDS='Humanoids Species Pack'

EXPANSION_ID_LITHOIDS='lithoids'
EXPANSION_NAME_LITHOIDS='Lithoids Species Pack'

EXPANSION_ID_NECROIDS='necroids'
EXPANSION_NAME_NECROIDS='Necroids Species Pack'

EXPANSION_ID_AQUATICS='aquatics'
EXPANSION_NAME_AQUATICS='Aquatics Species Pack'

EXPANSION_ID_TOXOIDS='toxoids'
EXPANSION_NAME_TOXOIDS='Toxoids Species Pack'

# Archives

## Plantoids

ARCHIVE_BASE_PLANTOID_56_NAME='stellaris_plantoids_species_pack_3_12_5_74193.sh'
ARCHIVE_BASE_PLANTOID_56_MD5='c97796440232a0afa39a793efae40c67'
ARCHIVE_BASE_PLANTOID_56_SIZE='837'
ARCHIVE_BASE_PLANTOID_56_VERSION='3.12.5-gog74193'
ARCHIVE_BASE_PLANTOID_56_URL='https://www.gog.com/game/stellaris_plantoids_species_pack'

ARCHIVE_BASE_PLANTOID_55_NAME='stellaris_plantoids_species_pack_3_12_4_1_74025.sh'
ARCHIVE_BASE_PLANTOID_55_MD5='270742bc4ec4b9fdb95c6e2b9859bd39'
ARCHIVE_BASE_PLANTOID_55_SIZE='837'
ARCHIVE_BASE_PLANTOID_55_VERSION='3.12.4-gog74025'

ARCHIVE_BASE_PLANTOID_54_NAME='stellaris_plantoids_species_pack_3_12_2_73401.sh'
ARCHIVE_BASE_PLANTOID_54_MD5='733dc8f83132aa0ef864a9c05a79f928'
ARCHIVE_BASE_PLANTOID_54_SIZE='837'
ARCHIVE_BASE_PLANTOID_54_VERSION='3.12.2-gog73401'

ARCHIVE_BASE_PLANTOID_53_NAME='stellaris_plantoids_species_pack_3_12_1_73183.sh'
ARCHIVE_BASE_PLANTOID_53_MD5='5ddf59900abe04cd2b7c940a3578f80d'
ARCHIVE_BASE_PLANTOID_53_SIZE='837'
ARCHIVE_BASE_PLANTOID_53_VERSION='3.12.1-gog73183'

ARCHIVE_BASE_PLANTOID_52_NAME='stellaris_plantoids_species_pack_3_11_3_0_72561.sh'
ARCHIVE_BASE_PLANTOID_52_MD5='c301172fde38bcd14b9e7546f35e49d2'
ARCHIVE_BASE_PLANTOID_52_SIZE='837'
ARCHIVE_BASE_PLANTOID_52_VERSION='3.11.3-gog72561'

ARCHIVE_BASE_PLANTOID_49_NAME='stellaris_plantoids_species_pack_3_10_4_70670.sh'
ARCHIVE_BASE_PLANTOID_49_MD5='fc70ea7215520e885c61d072463b9be4'
ARCHIVE_BASE_PLANTOID_49_SIZE='837'
ARCHIVE_BASE_PLANTOID_49_VERSION='3.10.4-gog70670'

ARCHIVE_BASE_PLANTOID_43_NAME='stellaris_plantoids_species_pack_3_9_3_68314.sh'
ARCHIVE_BASE_PLANTOID_43_MD5='f38e8c826f876f52cea68b69f85ca079'
ARCHIVE_BASE_PLANTOID_43_SIZE='1156'
ARCHIVE_BASE_PLANTOID_43_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_PLANTOID_40_NAME='stellaris_plantoids_species_pack_3_8_4_1_65337.sh'
ARCHIVE_BASE_PLANTOID_40_MD5='c64fed3a260b17bdb07e439dc20304c7'
ARCHIVE_BASE_PLANTOID_40_SIZE='1200'
ARCHIVE_BASE_PLANTOID_40_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_PLANTOID_39_NAME='stellaris_plantoids_species_pack_3_8_3_1_64953.sh'
ARCHIVE_BASE_PLANTOID_39_MD5='7b0cec949d962b027bc7bd108d79eeaf'
ARCHIVE_BASE_PLANTOID_39_SIZE='1200'
ARCHIVE_BASE_PLANTOID_39_VERSION='3.8.3.1-gog64953'

ARCHIVE_BASE_PLANTOID_36_NAME='stellaris_plantoids_species_pack_3_7_4_63489.sh'
ARCHIVE_BASE_PLANTOID_36_MD5='5a2a9101e09cddc83e29c802b33639ed'
ARCHIVE_BASE_PLANTOID_36_SIZE='1200'
ARCHIVE_BASE_PLANTOID_36_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_PLANTOID_33_NAME='stellaris_plantoids_species_pack_3_6_1_60754.sh'
ARCHIVE_BASE_PLANTOID_33_MD5='298bdd7c0f717f90c2045d0c9a68c1c9'
ARCHIVE_BASE_PLANTOID_33_SIZE='1200'
ARCHIVE_BASE_PLANTOID_33_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_PLANTOID_31_NAME='stellaris_plantoids_species_pack_3_5_3_59410.sh'
ARCHIVE_BASE_PLANTOID_31_MD5='fabc6b9d5580dac6a456da962a765709'
ARCHIVE_BASE_PLANTOID_31_SIZE='1200'
ARCHIVE_BASE_PLANTOID_31_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_PLANTOID_29_NAME='stellaris_plantoids_species_pack_3_4_5_56913.sh'
ARCHIVE_BASE_PLANTOID_29_MD5='b2b5023834509b4a5c2a12bb345380a1'
ARCHIVE_BASE_PLANTOID_29_SIZE='1200'
ARCHIVE_BASE_PLANTOID_29_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_PLANTOID_25_NAME='stellaris_plantoids_species_pack_3_3_4_54421.sh'
ARCHIVE_BASE_PLANTOID_25_MD5='b8ea82b781639c7031ea53d4e155c5d1'
ARCHIVE_BASE_PLANTOID_25_SIZE='1200'
ARCHIVE_BASE_PLANTOID_25_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_PLANTOID_21_NAME='stellaris_plantoids_species_pack_3_2_1_1_51520.sh'
ARCHIVE_BASE_PLANTOID_21_MD5='260d8bc704b93f307d31807efbb5568f'
ARCHIVE_BASE_PLANTOID_21_SIZE='1200'
ARCHIVE_BASE_PLANTOID_21_VERSION='3.2.1.1-gog51520'

ARCHIVE_BASE_PLANTOID_20_NAME='stellaris_plantoids_species_pack_3_1_1_50008.sh'
ARCHIVE_BASE_PLANTOID_20_MD5='fb947af6a98e45645b482a484bd6d42e'
ARCHIVE_BASE_PLANTOID_20_SIZE='1200'
ARCHIVE_BASE_PLANTOID_20_VERSION='3.1.1-gog50008'

ARCHIVE_BASE_PLANTOID_19_NAME='stellaris_plantoids_species_pack_3_0_3_47193.sh'
ARCHIVE_BASE_PLANTOID_19_MD5='d1dc616e45d6d035ed3414687228f95a'
ARCHIVE_BASE_PLANTOID_19_SIZE='1200'
ARCHIVE_BASE_PLANTOID_19_VERSION='3.0.3-gog47193'

## Humanoids

ARCHIVE_BASE_HUMANOIDS_56_NAME='stellaris_humanoids_species_pack_3_12_5_74193.sh'
ARCHIVE_BASE_HUMANOIDS_56_MD5='f7fa5900c87f3fb8cd43d9dcead97de2'
ARCHIVE_BASE_HUMANOIDS_56_SIZE='116312'
ARCHIVE_BASE_HUMANOIDS_56_VERSION='3.12.5-gog74193'
ARCHIVE_BASE_HUMANOIDS_56_URL='https://www.gog.com/game/stellaris_humanoids_species_pack'

ARCHIVE_BASE_HUMANOIDS_55_NAME='stellaris_humanoids_species_pack_3_12_4_1_74025.sh'
ARCHIVE_BASE_HUMANOIDS_55_MD5='001eda53219385a7c112a3f6ddaff7f9'
ARCHIVE_BASE_HUMANOIDS_55_SIZE='116312'
ARCHIVE_BASE_HUMANOIDS_55_VERSION='3.12.4-gog74025'

ARCHIVE_BASE_HUMANOIDS_54_NAME='stellaris_humanoids_species_pack_3_12_2_73401.sh'
ARCHIVE_BASE_HUMANOIDS_54_MD5='56a8b2c43e30b779ad0352bc21f23f63'
ARCHIVE_BASE_HUMANOIDS_54_SIZE='116312'
ARCHIVE_BASE_HUMANOIDS_54_VERSION='3.12.2-gog73401'

ARCHIVE_BASE_HUMANOIDS_53_NAME='stellaris_humanoids_species_pack_3_12_1_73183.sh'
ARCHIVE_BASE_HUMANOIDS_53_MD5='d3cbb81ac3c037f43e24f41d74f83c9f'
ARCHIVE_BASE_HUMANOIDS_53_SIZE='116312'
ARCHIVE_BASE_HUMANOIDS_53_VERSION='3.12.1-gog73183'

ARCHIVE_BASE_HUMANOIDS_52_NAME='stellaris_humanoids_species_pack_3_11_3_0_72561.sh'
ARCHIVE_BASE_HUMANOIDS_52_MD5='833ef910df4b00cfb7e3177b7525bee9'
ARCHIVE_BASE_HUMANOIDS_52_SIZE='116312'
ARCHIVE_BASE_HUMANOIDS_52_VERSION='3.11.3-gog72561'

ARCHIVE_BASE_HUMANOIDS_49_NAME='stellaris_humanoids_species_pack_3_10_4_70670.sh'
ARCHIVE_BASE_HUMANOIDS_49_MD5='515dd7f2ae1c68fe53a589f77b7af19c'
ARCHIVE_BASE_HUMANOIDS_49_SIZE='116312'
ARCHIVE_BASE_HUMANOIDS_49_VERSION='3.10.4-gog70670'

ARCHIVE_BASE_HUMANOIDS_43_NAME='stellaris_humanoids_species_pack_3_9_3_68314.sh'
ARCHIVE_BASE_HUMANOIDS_43_MD5='d970689331dfae6ad559b4dd8d146080'
ARCHIVE_BASE_HUMANOIDS_43_SIZE='116636'
ARCHIVE_BASE_HUMANOIDS_43_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_HUMANOIDS_40_NAME='stellaris_humanoids_species_pack_3_8_4_1_65337.sh'
ARCHIVE_BASE_HUMANOIDS_40_MD5='435cdbbe3a8affded29b3b6f9d36125a'
ARCHIVE_BASE_HUMANOIDS_40_SIZE='120000'
ARCHIVE_BASE_HUMANOIDS_40_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_HUMANOIDS_36_NAME='stellaris_humanoids_species_pack_3_7_4_63489.sh'
ARCHIVE_BASE_HUMANOIDS_36_MD5='de7661496eba8a9d125b44f3075a71b7'
ARCHIVE_BASE_HUMANOIDS_36_SIZE='120000'
ARCHIVE_BASE_HUMANOIDS_36_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_HUMANOIDS_33_NAME='stellaris_humanoids_species_pack_3_6_1_60754.sh'
ARCHIVE_BASE_HUMANOIDS_33_MD5='5124b47dce3c7a7282087e521920fee9'
ARCHIVE_BASE_HUMANOIDS_33_SIZE='120000'
ARCHIVE_BASE_HUMANOIDS_33_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_HUMANOIDS_31_NAME='stellaris_humanoids_species_pack_3_5_3_59410.sh'
ARCHIVE_BASE_HUMANOIDS_31_MD5='9f92e8b6853b26bc31da38b5a0991a37'
ARCHIVE_BASE_HUMANOIDS_31_SIZE='120000'
ARCHIVE_BASE_HUMANOIDS_31_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_HUMANOIDS_29_NAME='stellaris_humanoids_species_pack_3_4_5_56913.sh'
ARCHIVE_BASE_HUMANOIDS_29_MD5='5fcd93a54b01f93bae743d49bf61860b'
ARCHIVE_BASE_HUMANOIDS_29_SIZE='120000'
ARCHIVE_BASE_HUMANOIDS_29_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_HUMANOIDS_25_NAME='stellaris_humanoids_species_pack_3_3_4_54421.sh'
ARCHIVE_BASE_HUMANOIDS_25_MD5='b7ccaa9303516274f7945882bd6a2d2f'
ARCHIVE_BASE_HUMANOIDS_25_SIZE='120000'
ARCHIVE_BASE_HUMANOIDS_25_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_HUMANOIDS_21_NAME='stellaris_humanoids_species_pack_3_2_1_1_51520.sh'
ARCHIVE_BASE_HUMANOIDS_21_MD5='d56625b5ce55405530929bea32852f54'
ARCHIVE_BASE_HUMANOIDS_21_SIZE='120000'
ARCHIVE_BASE_HUMANOIDS_21_VERSION='3.2.1.1-gog51520'

ARCHIVE_BASE_HUMANOIDS_20_NAME='stellaris_humanoids_species_pack_3_1_1_50008.sh'
ARCHIVE_BASE_HUMANOIDS_20_MD5='974908ceeb80ade57dfa00c957604d06'
ARCHIVE_BASE_HUMANOIDS_20_SIZE='120000'
ARCHIVE_BASE_HUMANOIDS_20_VERSION='3.1.1-gog50008'

ARCHIVE_BASE_HUMANOIDS_19_NAME='stellaris_humanoids_species_pack_3_0_3_47193.sh'
ARCHIVE_BASE_HUMANOIDS_19_MD5='9dc8511383a7c36c54660d6d77d61117'
ARCHIVE_BASE_HUMANOIDS_19_SIZE='120000'
ARCHIVE_BASE_HUMANOIDS_19_VERSION='3.0.3-gog47193'

## Lithoids

ARCHIVE_BASE_LITHOIDS_44_NAME='stellaris_lithoids_species_pack_3_12_5_74193.sh'
ARCHIVE_BASE_LITHOIDS_44_MD5='bc4810ff3047e688c1ec0ae0991987ae'
ARCHIVE_BASE_LITHOIDS_44_SIZE='52603'
ARCHIVE_BASE_LITHOIDS_44_VERSION='3.12.5-gog74193'
ARCHIVE_BASE_LITHOIDS_44_URL='https://www.gog.com/game/stellaris_lithoids_species_pack'

ARCHIVE_BASE_LITHOIDS_43_NAME='stellaris_lithoids_species_pack_3_12_4_1_74025.sh'
ARCHIVE_BASE_LITHOIDS_43_MD5='4fb488d3088126135d1fa6a2435e1165'
ARCHIVE_BASE_LITHOIDS_43_SIZE='52603'
ARCHIVE_BASE_LITHOIDS_43_VERSION='3.12.4-gog74025'

ARCHIVE_BASE_LITHOIDS_42_NAME='stellaris_lithoids_species_pack_3_12_2_73401.sh'
ARCHIVE_BASE_LITHOIDS_42_MD5='cdd908648182b22d1ec0661f35c9e8b9'
ARCHIVE_BASE_LITHOIDS_42_SIZE='52603'
ARCHIVE_BASE_LITHOIDS_42_VERSION='3.12.2-gog73401'

ARCHIVE_BASE_LITHOIDS_41_NAME='stellaris_lithoids_species_pack_3_12_1_73183.sh'
ARCHIVE_BASE_LITHOIDS_41_MD5='6d92087f30f2e219b11663ed3537e194'
ARCHIVE_BASE_LITHOIDS_41_SIZE='52603'
ARCHIVE_BASE_LITHOIDS_41_VERSION='3.12.1-gog73183'

ARCHIVE_BASE_LITHOIDS_40_NAME='stellaris_lithoids_species_pack_3_11_3_0_72561.sh'
ARCHIVE_BASE_LITHOIDS_40_MD5='8ca00268fd2b3b4fb611b65bc2f4edb7'
ARCHIVE_BASE_LITHOIDS_40_SIZE='52603'
ARCHIVE_BASE_LITHOIDS_40_VERSION='3.11.3-gog72561'

ARCHIVE_BASE_LITHOIDS_37_NAME='stellaris_lithoids_species_pack_3_10_4_70670.sh'
ARCHIVE_BASE_LITHOIDS_37_MD5='96caaa7c76349f34823372cc7f9dc769'
ARCHIVE_BASE_LITHOIDS_37_SIZE='52603'
ARCHIVE_BASE_LITHOIDS_37_VERSION='3.10.4-gog70670'

ARCHIVE_BASE_LITHOIDS_31_NAME='stellaris_lithoids_species_pack_3_9_3_68314.sh'
ARCHIVE_BASE_LITHOIDS_31_MD5='baecdaa00168fe891ff419b71334f313'
ARCHIVE_BASE_LITHOIDS_31_SIZE='52924'
ARCHIVE_BASE_LITHOIDS_31_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_LITHOIDS_28_NAME='stellaris_lithoids_species_pack_3_8_4_1_65337.sh'
ARCHIVE_BASE_LITHOIDS_28_MD5='65723d6948a9380c1397b280f9bc20f4'
ARCHIVE_BASE_LITHOIDS_28_SIZE='53000'
ARCHIVE_BASE_LITHOIDS_28_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_LITHOIDS_24_NAME='stellaris_lithoids_species_pack_3_7_4_63489.sh'
ARCHIVE_BASE_LITHOIDS_24_MD5='bfc5632131852032fda229260aa179d6'
ARCHIVE_BASE_LITHOIDS_24_SIZE='53000'
ARCHIVE_BASE_LITHOIDS_24_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_LITHOIDS_21_NAME='stellaris_lithoids_species_pack_3_6_1_60754.sh'
ARCHIVE_BASE_LITHOIDS_21_MD5='0adc3e342f420e26a04b256595eee248'
ARCHIVE_BASE_LITHOIDS_21_SIZE='53000'
ARCHIVE_BASE_LITHOIDS_21_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_LITHOIDS_19_NAME='stellaris_lithoids_species_pack_3_5_3_59410.sh'
ARCHIVE_BASE_LITHOIDS_19_MD5='30bac0aa5302f556fb13511df2e8194b'
ARCHIVE_BASE_LITHOIDS_19_SIZE='53000'
ARCHIVE_BASE_LITHOIDS_19_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_LITHOIDS_17_NAME='stellaris_lithoids_species_pack_3_4_5_56913.sh'
ARCHIVE_BASE_LITHOIDS_17_MD5='54fb17af3ed8b442074c83cf2b818693'
ARCHIVE_BASE_LITHOIDS_17_SIZE='53000'
ARCHIVE_BASE_LITHOIDS_17_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_LITHOIDS_13_NAME='stellaris_lithoids_species_pack_3_3_4_54421.sh'
ARCHIVE_BASE_LITHOIDS_13_MD5='cde1e9ed0deaeff8850242e4157783be'
ARCHIVE_BASE_LITHOIDS_13_SIZE='53000'
ARCHIVE_BASE_LITHOIDS_13_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_LITHOIDS_9_NAME='stellaris_lithoids_species_pack_3_2_1_1_51520.sh'
ARCHIVE_BASE_LITHOIDS_9_MD5='ed5aca5df6d72a84f0572200e1d432fe'
ARCHIVE_BASE_LITHOIDS_9_SIZE='53000'
ARCHIVE_BASE_LITHOIDS_9_VERSION='3.2.1.1-gog51520'

ARCHIVE_BASE_LITHOIDS_8_NAME='stellaris_lithoids_species_pack_3_1_1_50008.sh'
ARCHIVE_BASE_LITHOIDS_8_MD5='c935a54a2e9ac78d195440d7ca1391f9'
ARCHIVE_BASE_LITHOIDS_8_SIZE='53000'
ARCHIVE_BASE_LITHOIDS_8_VERSION='3.1.1-gog50008'

ARCHIVE_BASE_LITHOIDS_7_NAME='stellaris_lithoids_species_pack_3_0_3_47193.sh'
ARCHIVE_BASE_LITHOIDS_7_MD5='44a8e1008468825af82ec138be388fe9'
ARCHIVE_BASE_LITHOIDS_7_SIZE='53000'
ARCHIVE_BASE_LITHOIDS_7_VERSION='3.0.3-gog47193'

## Necroids

ARCHIVE_BASE_NECROIDS_29_NAME='stellaris_necroids_species_pack_3_12_5_74193.sh'
ARCHIVE_BASE_NECROIDS_29_MD5='3df3d9f80ed1d79a2f0f412535b77d54'
ARCHIVE_BASE_NECROIDS_29_SIZE='49209'
ARCHIVE_BASE_NECROIDS_29_VERSION='3.12.5-gog74193'
ARCHIVE_BASE_NECROIDS_29_URL='https://www.gog.com/game/stellaris_necroids_species_pack'

ARCHIVE_BASE_NECROIDS_28_NAME='stellaris_necroids_species_pack_3_12_4_1_74025.sh'
ARCHIVE_BASE_NECROIDS_28_MD5='25d7cabea1f2a2c3dae4f00bbae0fd49'
ARCHIVE_BASE_NECROIDS_28_SIZE='49209'
ARCHIVE_BASE_NECROIDS_28_VERSION='3.12.4-gog74025'

ARCHIVE_BASE_NECROIDS_27_NAME='stellaris_necroids_species_pack_3_12_2_73401.sh'
ARCHIVE_BASE_NECROIDS_27_MD5='bd3fc243e8b5f271f28e412707dc9a75'
ARCHIVE_BASE_NECROIDS_27_SIZE='49209'
ARCHIVE_BASE_NECROIDS_27_VERSION='3.12.2-gog73401'

ARCHIVE_BASE_NECROIDS_26_NAME='stellaris_necroids_species_pack_3_12_1_73183.sh'
ARCHIVE_BASE_NECROIDS_26_MD5='a5107b771305fda5b471a28366b81d47'
ARCHIVE_BASE_NECROIDS_26_SIZE='49209'
ARCHIVE_BASE_NECROIDS_26_VERSION='3.12.1-gog73183'

ARCHIVE_BASE_NECROIDS_25_NAME='stellaris_necroids_species_pack_3_11_3_0_72561.sh'
ARCHIVE_BASE_NECROIDS_25_MD5='d0f677482b688ebe46e0abf20ece8477'
ARCHIVE_BASE_NECROIDS_25_SIZE='49209'
ARCHIVE_BASE_NECROIDS_25_VERSION='3.11.3-gog72561'

ARCHIVE_BASE_NECROIDS_22_NAME='stellaris_necroids_species_pack_3_10_4_70670.sh'
ARCHIVE_BASE_NECROIDS_22_MD5='5549b1dfec82af2de64537ed751a1920'
ARCHIVE_BASE_NECROIDS_22_SIZE='49209'
ARCHIVE_BASE_NECROIDS_22_VERSION='3.10.4-gog70670'

ARCHIVE_BASE_NECROIDS_16_NAME='stellaris_necroids_species_pack_3_9_3_68314.sh'
ARCHIVE_BASE_NECROIDS_16_MD5='8afbc28fb3af625dd145381e44fe7bde'
ARCHIVE_BASE_NECROIDS_16_SIZE='49524'
ARCHIVE_BASE_NECROIDS_16_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_NECROIDS_13_NAME='stellaris_necroids_species_pack_3_8_4_1_65337.sh'
ARCHIVE_BASE_NECROIDS_13_MD5='2614b147a120b97e0d5e4f0a24719f82'
ARCHIVE_BASE_NECROIDS_13_SIZE='50000'
ARCHIVE_BASE_NECROIDS_13_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_NECROIDS_9_NAME='stellaris_necroids_species_pack_3_7_4_63489.sh'
ARCHIVE_BASE_NECROIDS_9_MD5='631269beefca458e901a727af53e09d0'
ARCHIVE_BASE_NECROIDS_9_SIZE='50000'
ARCHIVE_BASE_NECROIDS_9_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_NECROIDS_6_NAME='stellaris_necroids_species_pack_3_6_1_60754.sh'
ARCHIVE_BASE_NECROIDS_6_MD5='13605c18c7d483b3c8abeff2d60c65f7'
ARCHIVE_BASE_NECROIDS_6_SIZE='50000'
ARCHIVE_BASE_NECROIDS_6_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_NECROIDS_4_NAME='stellaris_necroids_species_pack_3_5_3_59410.sh'
ARCHIVE_BASE_NECROIDS_4_MD5='23faec896d52d6f2773e19838f365113'
ARCHIVE_BASE_NECROIDS_4_SIZE='50000'
ARCHIVE_BASE_NECROIDS_4_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_NECROIDS_2_NAME='stellaris_necroids_species_pack_3_4_5_56913.sh'
ARCHIVE_BASE_NECROIDS_2_MD5='e64ecf03e49671cedf3e164709a5837a'
ARCHIVE_BASE_NECROIDS_2_SIZE='50000'
ARCHIVE_BASE_NECROIDS_2_VERSION='3.4.5-gog56913'

## Aquatics

ARCHIVE_BASE_AQUATICS_27_NAME='stellaris_aquatics_species_pack_3_12_5_74193.sh'
ARCHIVE_BASE_AQUATICS_27_MD5='0d9d2d2a38c60025b79e72011b52837c'
ARCHIVE_BASE_AQUATICS_27_SIZE='57544'
ARCHIVE_BASE_AQUATICS_27_VERSION='3.12.5-gog74193'
ARCHIVE_BASE_AQUATICS_27_URL='https://www.gog.com/game/stellaris_aquatics_species_pack'

ARCHIVE_BASE_AQUATICS_26_NAME='stellaris_aquatics_species_pack_3_12_4_1_74025.sh'
ARCHIVE_BASE_AQUATICS_26_MD5='d7875e26717ae5a7c86c660f0f9408d2'
ARCHIVE_BASE_AQUATICS_26_SIZE='57544'
ARCHIVE_BASE_AQUATICS_26_VERSION='3.12.4-gog74025'

ARCHIVE_BASE_AQUATICS_25_NAME='stellaris_aquatics_species_pack_3_12_2_73401.sh'
ARCHIVE_BASE_AQUATICS_25_MD5='18bd0132d65536988134a53ce5ad1f63'
ARCHIVE_BASE_AQUATICS_25_SIZE='57544'
ARCHIVE_BASE_AQUATICS_25_VERSION='3.12.2-gog73401'

ARCHIVE_BASE_AQUATICS_24_NAME='stellaris_aquatics_species_pack_3_12_1_73183.sh'
ARCHIVE_BASE_AQUATICS_24_MD5='f57b66ee25468393a76333676b014401'
ARCHIVE_BASE_AQUATICS_24_SIZE='57544'
ARCHIVE_BASE_AQUATICS_24_VERSION='3.12.1-gog73183'

ARCHIVE_BASE_AQUATICS_23_NAME='stellaris_aquatics_species_pack_3_11_3_0_72561.sh'
ARCHIVE_BASE_AQUATICS_23_MD5='818beaf18d82951df0b1028eb0d7f78a'
ARCHIVE_BASE_AQUATICS_23_SIZE='120876'
ARCHIVE_BASE_AQUATICS_23_VERSION='3.11.3-gog72561'

ARCHIVE_BASE_AQUATICS_20_NAME='stellaris_aquatics_species_pack_3_10_4_70670.sh'
ARCHIVE_BASE_AQUATICS_20_MD5='335d95744fa5467cad87e276fb8d6997'
ARCHIVE_BASE_AQUATICS_20_SIZE='120876'
ARCHIVE_BASE_AQUATICS_20_VERSION='3.10.4-gog70670'

ARCHIVE_BASE_AQUATICS_14_NAME='stellaris_aquatics_species_pack_3_9_3_68314.sh'
ARCHIVE_BASE_AQUATICS_14_MD5='39294019e3f068916fea06f68e35b1ee'
ARCHIVE_BASE_AQUATICS_14_SIZE='121448'
ARCHIVE_BASE_AQUATICS_14_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_AQUATICS_11_NAME='stellaris_aquatics_species_pack_3_8_4_1_65337.sh'
ARCHIVE_BASE_AQUATICS_11_MD5='34a45daa4a4d1bf204dc9798917692b5'
ARCHIVE_BASE_AQUATICS_11_SIZE='130000'
ARCHIVE_BASE_AQUATICS_11_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_AQUATICS_7_NAME='stellaris_aquatics_species_pack_3_7_4_63489.sh'
ARCHIVE_BASE_AQUATICS_7_MD5='f825b3f150a7d936b04b3f5bd35d9f5b'
ARCHIVE_BASE_AQUATICS_7_SIZE='130000'
ARCHIVE_BASE_AQUATICS_7_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_AQUATICS_4_NAME='stellaris_aquatics_species_pack_3_6_1_60754.sh'
ARCHIVE_BASE_AQUATICS_4_MD5='5cfdb2861b8c3de9c83798799b477ad6'
ARCHIVE_BASE_AQUATICS_4_SIZE='130000'
ARCHIVE_BASE_AQUATICS_4_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_AQUATICS_2_NAME='stellaris_aquatics_species_pack_3_5_3_59410.sh'
ARCHIVE_BASE_AQUATICS_2_MD5='7e3210b2d64b851907a97ed3455ad035'
ARCHIVE_BASE_AQUATICS_2_SIZE='130000'
ARCHIVE_BASE_AQUATICS_2_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_AQUATICS_0_NAME='stellaris_aquatics_species_pack_3_4_5_56913.sh'
ARCHIVE_BASE_AQUATICS_0_MD5='0d6fe86d3ec24b114742a333b8de4a3b'
ARCHIVE_BASE_AQUATICS_0_SIZE='130000'
ARCHIVE_BASE_AQUATICS_0_VERSION='3.4.5-gog56913'

## Toxoids

ARCHIVE_BASE_TOXOIDS_20_NAME='stellaris_toxoids_species_pack_3_12_5_74193.sh'
ARCHIVE_BASE_TOXOIDS_20_MD5='788f0afe85d1f90c91567e3958ddcae1'
ARCHIVE_BASE_TOXOIDS_20_SIZE='41495'
ARCHIVE_BASE_TOXOIDS_20_VERSION='3.12.5-gog74193'
ARCHIVE_BASE_TOXOIDS_20_URL='https://www.gog.com/game/stellaris_toxoids_species_pack'

ARCHIVE_BASE_TOXOIDS_19_NAME='stellaris_toxoids_species_pack_3_12_4_1_74025.sh'
ARCHIVE_BASE_TOXOIDS_19_MD5='5ed15f2afe4197243b25a0c10c3d1f93'
ARCHIVE_BASE_TOXOIDS_19_SIZE='41495'
ARCHIVE_BASE_TOXOIDS_19_VERSION='3.12.4-gog74025'

ARCHIVE_BASE_TOXOIDS_18_NAME='stellaris_toxoids_species_pack_3_12_2_73401.sh'
ARCHIVE_BASE_TOXOIDS_18_MD5='154d04533036338269bbfe154432bd31'
ARCHIVE_BASE_TOXOIDS_18_SIZE='41495'
ARCHIVE_BASE_TOXOIDS_18_VERSION='3.12.2-gog73401'

ARCHIVE_BASE_TOXOIDS_17_NAME='stellaris_toxoids_species_pack_3_12_1_73183.sh'
ARCHIVE_BASE_TOXOIDS_17_MD5='43ea4a72bd0c90b37d18c472b209b097'
ARCHIVE_BASE_TOXOIDS_17_SIZE='41495'
ARCHIVE_BASE_TOXOIDS_17_VERSION='3.12.1-gog73183'

ARCHIVE_BASE_TOXOIDS_16_NAME='stellaris_toxoids_species_pack_3_11_3_0_72561.sh'
ARCHIVE_BASE_TOXOIDS_16_MD5='4dc7bf366e2e84febbe88f77057c018c'
ARCHIVE_BASE_TOXOIDS_16_SIZE='41495'
ARCHIVE_BASE_TOXOIDS_16_VERSION='3.11.3-gog72561'

ARCHIVE_BASE_TOXOIDS_13_NAME='stellaris_toxoids_species_pack_3_10_4_70670.sh'
ARCHIVE_BASE_TOXOIDS_13_MD5='ee41aba19af2f2f91bbe3c156bf614f5'
ARCHIVE_BASE_TOXOIDS_13_SIZE='41495'
ARCHIVE_BASE_TOXOIDS_13_VERSION='3.10.4-gog70670'

ARCHIVE_BASE_TOXOIDS_7_NAME='stellaris_toxoids_species_pack_3_9_3_68314.sh'
ARCHIVE_BASE_TOXOIDS_7_MD5='69ee5d18ffe310c64ee61934ec64aa1f'
ARCHIVE_BASE_TOXOIDS_7_SIZE='41812'
ARCHIVE_BASE_TOXOIDS_7_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_TOXOIDS_4_NAME='stellaris_toxoids_species_pack_3_8_4_1_65337.sh'
ARCHIVE_BASE_TOXOIDS_4_MD5='90926bd74621bf180a074d4721b594f9'
ARCHIVE_BASE_TOXOIDS_4_SIZE='42000'
ARCHIVE_BASE_TOXOIDS_4_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_TOXOIDS_0_NAME='stellaris_toxoids_species_pack_3_7_4_63489.sh'
ARCHIVE_BASE_TOXOIDS_0_MD5='e6af2b93063b67bc78d6a44c70caee1c'
ARCHIVE_BASE_TOXOIDS_0_SIZE='42000'
ARCHIVE_BASE_TOXOIDS_0_VERSION='3.7.4-gog63489'


CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_MAIN_FILES='
dlc'

PKG_MAIN_DEPS="$GAME_ID"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_default

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
