#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Jazz Jackrabbit 2
###

script_version=20240430.5

PLAYIT_COMPATIBILITY_LEVEL='2.28'

GAME_ID='jazz-jackrabbit-2'
GAME_NAME='Jazz Jackrabbit 2'

GAME_ID_JJ2PLUS="${GAME_ID}-jj2plus"
GAME_NAME_JJ2PLUS="$GAME_NAME - JJ2+"

GAME_ID_CHRISTMAS="${GAME_ID}-the-christmas-chronicles"
GAME_NAME_CHRISTMAS="$GAME_NAME - The Christmas Chronicles"

# Game archives

## Jazz Jackrabbit 2 (including The Secret Files)

ARCHIVE_BASE_1_NAME='setup_jazz_jackrabbit_2_1.24hf_(16886).exe'
ARCHIVE_BASE_1_MD5='45be80bad040ea821bc6096abe6f3196'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_SIZE='66986'
ARCHIVE_BASE_1_VERSION='1.24-gog16886'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/jazz_jackrabbit_2_collection'

## Support for this archive can only be restored after ./play.it gains support for multiple archives with an identical name.
## cf. https://forge.dotslashplay.it/play.it/scripts/-/issues/355
#ARCHIVE_BASE_0_NAME='setup_jazz_jackrabbit_2_1.24hf_(16886).exe'
#ARCHIVE_BASE_0_MD5='48a48258ed60b24068cbbb2f110b049b'
#ARCHIVE_BASE_0_TYPE='innosetup'
#ARCHIVE_BASE_0_SIZE='67000'
#ARCHIVE_BASE_0_VERSION='1.24-gog16886'

## Jazz Jackrabbit 2 (including The Secret Files) + JJ2+ expansion

ARCHIVE_BASE_JJ2PLUS_0_NAME='setup_jazz_jackrabbit_2_1.24_jj2_(5.9)_(46861).exe'
ARCHIVE_BASE_JJ2PLUS_0_MD5='94f8477d51e35b4cdc6b3d999b502580'
ARCHIVE_BASE_JJ2PLUS_0_TYPE='innosetup'
ARCHIVE_BASE_JJ2PLUS_0_SIZE='78000'
ARCHIVE_BASE_JJ2PLUS_0_VERSION='1.24-gog46861'
ARCHIVE_BASE_JJ2PLUS_0_URL='https://www.gog.com/game/jazz_jackrabbit_2_collection'

## Jazz Jackrabbit 2 - The Christmas Chronicles

ARCHIVE_BASE_CHRISTMAS_0_NAME='setup_jazz_jackrabbit_2_cc_1.2x_(16742).exe'
ARCHIVE_BASE_CHRISTMAS_0_MD5='3289263ea6bad8bc35f02176e22109f2'
ARCHIVE_BASE_CHRISTMAS_0_TYPE='innosetup'
ARCHIVE_BASE_CHRISTMAS_0_SIZE='70000'
ARCHIVE_BASE_CHRISTMAS_0_VERSION='1.2x-gog16742'
ARCHIVE_BASE_CHRISTMAS_0_URL='https://www.gog.com/game/jazz_jackrabbit_2_collection'

## Jazz² Resurrection (native engine)

ARCHIVE_JAZZ2NATIVE_1_NAME='Jazz2_2.6.0_Linux.zip'
ARCHIVE_JAZZ2NATIVE_1_MD5='ff2ff3acc2213f4133ca8138603feb67'
ARCHIVE_JAZZ2NATIVE_1_SIZE='29553'
ARCHIVE_JAZZ2NATIVE_1_VERSION='2.6.0'
ARCHIVE_JAZZ2NATIVE_1_URL='http://deat.tk/jazz2/'

ARCHIVE_JAZZ2NATIVE_0_NAME='Jazz2_1.0.0_Linux.zip'
ARCHIVE_JAZZ2NATIVE_0_MD5='868ce9ac55ee3a085eed5503d7647a67'
ARCHIVE_JAZZ2NATIVE_0_VERSION='1.0.0'
ARCHIVE_JAZZ2NATIVE_0_SIZE='8000'

# Archives content

## Jazz Jackrabbit 2

CONTENT_PATH_DEFAULT='.'
CONTENT_PATH_DEFAULT_0='app'
CONTENT_PATH_DEFAULT_CHRISTMAS_0='app'
CONTENT_GAME_DATA_FILES='
html
jcshelp
tiles
userlevels
*.asc
*.it
*.j2?
*.j2as
*.mo3
*.mod
*.mut
*.pal
*.s3m
*.wav'
CONTENT_DOC_DATA_FILES='
*.doc
*.html
*.pdf
*.txt'

## Jazz² Resurrection

CONTENT_GAME_BIN_PATH='x64'
CONTENT_GAME_BIN_PATH_JAZZ2NATIVE_0='64-bit'
CONTENT_GAME_BIN_FILES='
Content
jazz2
jazz2_sdl2'

## TODO: Distinct packages could be built for the default build and the SDL one.

APP_MAIN_EXE='jazz2'
APP_MAIN_ICON='jazz2.exe'

APP_SDL_EXE='jazz2_sdl2'
APP_SDL_ICON='jazz2.exe'
APP_SDL_ID="${GAME_ID}-sdl"
APP_SDL_ID_JJ2PLUS="${GAME_ID_JJ2PLUS}-sdl"
APP_SDL_ID_CHRISTMAS="${GAME_ID_CHRISTMAS}-sdl"
APP_SDL_NAME="$GAME_NAME (SDL)"
APP_SDL_NAME_JJ2PLUS="$GAME_NAME_JJ2PLUS (SDL)"
APP_SDL_NAME_CHRISTMAS="$GAME_NAME_CHRISTMAS (SDL)"

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_ID_JJ2PLUS="${GAME_ID_JJ2PLUS}-data"
PKG_DATA_ID_CHRISTMAS="${GAME_ID_CHRISTMAS}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPS_JJ2PLUS="$PKG_DATA_ID_JJ2PLUS"
PKG_BIN_DEPS_CHRISTMAS="$PKG_DATA_ID_CHRISTMAS"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libgcc_s.so.1
libglfw.so.3
libm.so.6
libopenal.so.1
libOpenGL.so.0
libopenmpt.so.0
libSDL2-2.0.so.0
libstdc++.so.6
libvorbisfile.so.3
libz.so.1'
PKG_BIN_DEPENDENCIES_LIBRARIES_JAZZ2NATIVE_0='
libc.so.6
libgcc_s.so.1
libGLEW.so.2.2
libglfw.so.3
libGL.so.1
libGLX.so.0
libICE.so.6
libm.so.6
libopenal.so.1
libOpenGL.so.0
libopenmpt.so.0
libSDL2-2.0.so.0
libSM.so.6
libstdc++.so.6
libX11.so.6
libXext.so.6
libz.so.1'
## Ensure smooth upgrades from packages generated with pre-20240430.10 game scripts
PKG_BIN_PROVIDES="${PKG_BIN_PROVIDES:-}
jazz-jackrabbit-2-bin"
PKG_BIN_PROVIDES_CHRISTMAS="${PKG_BIN_PROVIDES_CHRISTMAS:-}
jazz-jackrabbit-2-the-christmas-chronicles-bin"
### This one is not actually required, but prevents the JJ2+ package from conflicting with the regular one.
PKG_BIN_PROVIDES_JJ2PLUS="${PKG_BIN_PROVIDES_JJ2PLUS:-}
jazz-jackrabbit-2-jj2plus-bin"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Check for the presence of required extra archives

archive_initialize_required \
	'ARCHIVE_JAZZ2NATIVE' \
	'ARCHIVE_JAZZ2NATIVE_1' \
	'ARCHIVE_JAZZ2NATIVE_0'
installer_release=$(package_version | cut --delimiter='-' --fields=2)
case "$(archive_name 'ARCHIVE_JAZZ2NATIVE')" in
	("$(archive_name 'ARCHIVE_JAZZ2NATIVE_1')")
		export "$(current_archive)_VERSION=${ARCHIVE_JAZZ2NATIVE_1_VERSION}-${installer_release}"
	;;
	("$(archive_name 'ARCHIVE_JAZZ2NATIVE_0')")
		export "$(current_archive)_VERSION=${ARCHIVE_JAZZ2NATIVE_0_VERSION}-${installer_release}"
		export CONTENT_GAME_BIN_PATH="$CONTENT_GAME_BIN_PATH_JAZZ2NATIVE_0"
		export PKG_BIN_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES_JAZZ2NATIVE_0"
	;;
esac

# Extract game data

archive_extraction_default
archive_extraction 'ARCHIVE_JAZZ2NATIVE'

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion 'GAME_DATA' 'PKG_DATA' "$(path_game_data)/Source"
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
