#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Gibbous - A Cthulhu Adventure
###

script_version=20240410.1

PLAYIT_COMPATIBILITY_LEVEL='2.28'

GAME_ID='gibbous-a-cthulhu-adventure'
GAME_NAME='Gibbous - A Cthulhu Adventure'

ARCHIVE_BASE_0_NAME='gibbous_a_cthulhu_adventure_x86_64_1_8_35773.sh'
ARCHIVE_BASE_0_MD5='c92315690df34ee8affa24f184486ccb'
ARCHIVE_BASE_0_SIZE='9500000'
ARCHIVE_BASE_0_VERSION='1.8-gog35773'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/gibbous_a_cthulhu_adventure'

UNITY3D_NAME='Gibbous - A Cthulhu Adventure'
UNITY3D_PLUGINS='
ScreenSelector.so'
## If libsteam_api.so is not included, the game crashes after the opening video played when starting a new game.
UNITY3D_PLUGINS="${UNITY3D_PLUGINS:-}"'
libsteam_api.so'

CONTENT_PATH_DEFAULT='data/noarch/game'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libgdk_pixbuf-2.0.so.0
libglib-2.0.so.0
libgobject-2.0.so.0
libgtk-x11-2.0.so.0
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6
libz.so.1'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
