#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Shadow Gambit
###

script_version=20231221.4

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID='shadow-gambit'
GAME_NAME='Shadow Gambit: The Cursed Crew'

GAME_ID_DEMO="${GAME_ID}-demo"
GAME_NAME_DEMO="$GAME_NAME (demo)"

ARCHIVE_BASE_0_NAME='setup_shadow_gambit_the_cursed_crew_1.2.133.f.r40893_(64bit)_(69829).exe'
ARCHIVE_BASE_0_MD5='b394c7866b3e2106b8659f76dcf3b814'
ARCHIVE_BASE_0_EXTRACTOR='innoextract'
## Do not convert the paths to lower case.
ARCHIVE_BASE_0_EXTRACTOR_OPTIONS=' '
ARCHIVE_BASE_0_PART1_NAME='setup_shadow_gambit_the_cursed_crew_1.2.133.f.r40893_(64bit)_(69829)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='33d84cef13cae8cb1a27e03101cda2cc'
ARCHIVE_BASE_0_PART2_NAME='setup_shadow_gambit_the_cursed_crew_1.2.133.f.r40893_(64bit)_(69829)-2.bin'
ARCHIVE_BASE_0_PART2_MD5='aa475cf51a8a6b9f151a63e7f8acd226'
ARCHIVE_BASE_0_PART3_NAME='setup_shadow_gambit_the_cursed_crew_1.2.133.f.r40893_(64bit)_(69829)-3.bin'
ARCHIVE_BASE_0_PART3_MD5='8019f8a20edf33e894a49ccc84fdf867'
ARCHIVE_BASE_0_PART4_NAME='setup_shadow_gambit_the_cursed_crew_1.2.133.f.r40893_(64bit)_(69829)-4.bin'
ARCHIVE_BASE_0_PART4_MD5='d499dd2ab3f31e1ddb7c6b6c6f9d35c7'
ARCHIVE_BASE_0_SIZE='27989056'
ARCHIVE_BASE_0_VERSION='1.2.133.f-gog69829'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/shadow_gambit_the_cursed_crew'

ARCHIVE_BASE_DEMO_0_NAME='setup_shadow_gambit_the_cursed_crew_demo_1.0.46.r37840.d_(64bit)_(66564).exe'
ARCHIVE_BASE_DEMO_0_MD5='ad6c5d562cb5166301b82311495eb4fc'
ARCHIVE_BASE_DEMO_0_EXTRACTOR='innoextract'
## Do not convert the paths to lower case.
ARCHIVE_BASE_DEMO_0_EXTRACTOR_OPTIONS=' '
ARCHIVE_BASE_DEMO_0_PART1_NAME='setup_shadow_gambit_the_cursed_crew_demo_1.0.46.r37840.d_(64bit)_(66564)-1.bin'
ARCHIVE_BASE_DEMO_0_PART1_MD5='2ed0f7c0fe3bcba3cfe562ff687743cc'
ARCHIVE_BASE_DEMO_0_PART2_NAME='setup_shadow_gambit_the_cursed_crew_demo_1.0.46.r37840.d_(64bit)_(66564)-2.bin'
ARCHIVE_BASE_DEMO_0_PART2_MD5='cf8746aaa4ff9b40366c562367155876'
ARCHIVE_BASE_DEMO_0_PART3_NAME='setup_shadow_gambit_the_cursed_crew_demo_1.0.46.r37840.d_(64bit)_(66564)-3.bin'
ARCHIVE_BASE_DEMO_0_PART3_MD5='190c8d547cd6f3217a10038079431c9c'
ARCHIVE_BASE_DEMO_0_SIZE='15729374'
ARCHIVE_BASE_DEMO_0_VERSION='1.0.46-gog66564'
ARCHIVE_BASE_DEMO_0_URL='https://www.gog.com/game/shadow_gambit_the_cursed_crew_demo'

UNITY3D_NAME='ShadowGambit_TCC'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_DATA_EXPANSION_YUKI_FILES="
${UNITY3D_NAME}_Data/StreamingAssets/aa/StandaloneWindows64/dlctrp_content_00"
CONTENT_GAME_DATA_EXPANSION_ZAGAN_FILES="
${UNITY3D_NAME}_Data/StreamingAssets/aa/StandaloneWindows64/dlcchc_content_00"
CONTENT_GAME_DATA_BUNDLES1_FILES="
${UNITY3D_NAME}_Data/StreamingAssets/aa/StandaloneWindows64/mis_*"
CONTENT_GAME_DATA_BUNDLES2_FILES="
${UNITY3D_NAME}_Data/StreamingAssets/aa/StandaloneWindows64/main_*"
CONTENT_GAME_DATA_BUNDLES3_FILES="
${UNITY3D_NAME}_Data/StreamingAssets/aa/StandaloneWindows64"

WINE_DIRECT3D_RENDERER='dxvk'
WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/Local/ShadowGambit_TCC'
WINE_PERSISTENT_DIRECTORIES_DEMO='
users/${USER}/AppData/Local/ShadowGambit_TCC_Demo'

PACKAGES_LIST='
PKG_BIN
PKG_DATA_EXPANSION_YUKI
PKG_DATA_EXPANSION_ZAGAN
PKG_DATA_BUNDLES1
PKG_DATA_BUNDLES2
PKG_DATA_BUNDLES3
PKG_DATA'
PACKAGES_LIST_DEMO='
PKG_BIN
PKG_DATA_BUNDLES1
PKG_DATA_BUNDLES2
PKG_DATA_BUNDLES3
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_ID_DEMO="${GAME_ID_DEMO}-data"
PKG_DATA_DESCRIPTION='data'

PKG_DATA_EXPANSION_ID="${PKG_DATA_ID}-expansion"
PKG_DATA_EXPANSION_YUKI_ID="${PKG_DATA_EXPANSION_ID}-yuki"
PKG_DATA_EXPANSION_ZAGAN_ID="${PKG_DATA_EXPANSION_ID}-zagan"
PKG_DATA_EXPANSION_DESCRIPTION="$PKG_DATA_DESCRIPTION - expansion"
PKG_DATA_EXPANSION_YUKI_DESCRIPTION="$PKG_DATA_EXPANSION_DESCRIPTION - Yuki's Wish"
PKG_DATA_EXPANSION_ZAGAN_DESCRIPTION="$PKG_DATA_EXPANSION_DESCRIPTION - Zagan's Ritual"
PKG_DATA_DEPS="${PKG_DATA_DEPS:-} $PKG_DATA_EXPANSION_YUKI_ID $PKG_DATA_EXPANSION_ZAGAN_ID"

PKG_DATA_BUNDLES_ID="${PKG_DATA_ID}-bundles"
PKG_DATA_BUNDLES1_ID="${PKG_DATA_BUNDLES_ID}-1"
PKG_DATA_BUNDLES2_ID="${PKG_DATA_BUNDLES_ID}-2"
PKG_DATA_BUNDLES3_ID="${PKG_DATA_BUNDLES_ID}-3"
PKG_DATA_BUNDLES_ID_DEMO="${PKG_DATA_ID_DEMO}-bundles"
PKG_DATA_BUNDLES1_ID_DEMO="${PKG_DATA_BUNDLES_ID_DEMO}-1"
PKG_DATA_BUNDLES2_ID_DEMO="${PKG_DATA_BUNDLES_ID_DEMO}-2"
PKG_DATA_BUNDLES3_ID_DEMO="${PKG_DATA_BUNDLES_ID_DEMO}-3"
PKG_DATA_BUNDLES_DESCRIPTION="$PKG_DATA_DESCRIPTION - bundles"
PKG_DATA_BUNDLES1_DESCRIPTION="$PKG_DATA_BUNDLES_DESCRIPTION - 1"
PKG_DATA_BUNDLES2_DESCRIPTION="$PKG_DATA_BUNDLES_DESCRIPTION - 2"
PKG_DATA_BUNDLES3_DESCRIPTION="$PKG_DATA_BUNDLES_DESCRIPTION - 3"
PKG_DATA_DEPS="${PKG_DATA_DEPS:-} $PKG_DATA_BUNDLES1_ID $PKG_DATA_BUNDLES2_ID $PKG_DATA_BUNDLES3_ID"
PKG_DATA_DEPS_DEMO="${PKG_DATA_DEPS_DEMO:-} $PKG_DATA_BUNDLES1_ID_DEMO $PKG_DATA_BUNDLES2_ID_DEMO $PKG_DATA_BUNDLES3_ID_DEMO"

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPS_DEMO="$PKG_DATA_ID_DEMO"
PKG_BIN_DEPENDENCIES_GSTREAMER_PLUGINS='
video/quicktime, variant=(string)iso'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	# Prevent the inclusion of unwanted files
	rm --force --recursive \
		'commonappdata' \
		'tmp'
)

# Include game data

set_current_package 'PKG_DATA'
icons_inclusion
content_inclusion_default

# Write launchers

set_current_package 'PKG_BIN'
launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
