#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# State of Mind
# send your bug reports to contact@dotslashplay.it
###

script_version=20230814.1

GAME_ID='state-of-mind'
GAME_NAME='State of Mind'

ARCHIVE_BASE_0='state_of_mind_1_2_24280_24687.sh'
ARCHIVE_BASE_0_MD5='e27071ec1041dc7e529f5fe590783f72'
ARCHIVE_BASE_0_SIZE='21000000'
ARCHIVE_BASE_0_VERSION='1.2.24280-gog24687'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/state_of_mind'

UNREALENGINE4_NAME='StateOfMind'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_DATA_CHUNK1_FILES="
${UNREALENGINE4_NAME}/Content/Paks/pakchunk0-LinuxNoEditor.pak
${UNREALENGINE4_NAME}/Content/Paks/pakchunk1-LinuxNoEditor.pak
${UNREALENGINE4_NAME}/Content/Paks/pakchunk2-LinuxNoEditor.pak"
CONTENT_GAME_DATA_CHUNK2_FILES="
${UNREALENGINE4_NAME}/Content/Paks/pakchunk3-LinuxNoEditor.pak
${UNREALENGINE4_NAME}/Content/Paks/pakchunk4-LinuxNoEditor.pak
${UNREALENGINE4_NAME}/Content/Paks/pakchunk5-LinuxNoEditor.pak"
CONTENT_GAME_DATA_CHUNK3_FILES="
${UNREALENGINE4_NAME}/Content/Paks/pakchunk6-LinuxNoEditor.pak
${UNREALENGINE4_NAME}/Content/Paks/pakchunk7-LinuxNoEditor.pak"
CONTENT_GAME_DATA_FILES="
${UNREALENGINE4_NAME}/Content
${UNREALENGINE4_NAME}.png
version.txt"
CONTENT_DOC_DATA_FILES="
LICENSE.txt"

APP_MAIN_EXE="${UNREALENGINE4_NAME}/Binaries/Linux/${UNREALENGINE4_NAME}-Linux-Shipping"
APP_MAIN_ICON="${UNREALENGINE4_NAME}.png"

PACKAGES_LIST='PKG_BIN PKG_DATA_CHUNK1 PKG_DATA_CHUNK2 PKG_DATA_CHUNK3 PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_DATA_CHUNK1_ID="${PKG_DATA_ID}-chunk1"
PKG_DATA_CHUNK1_DESCRIPTION="$PKG_DATA_DESCRIPTION - chunk 1"
PKG_DATA_DEPS="$PKG_DATA_DEPS $PKG_DATA_CHUNK1_ID"

PKG_DATA_CHUNK2_ID="${PKG_DATA_ID}-chunk2"
PKG_DATA_CHUNK2_DESCRIPTION="$PKG_DATA_DESCRIPTION - chunk 2"
PKG_DATA_DEPS="$PKG_DATA_DEPS $PKG_DATA_CHUNK2_ID"

PKG_DATA_CHUNK3_ID="${PKG_DATA_ID}-chunk3"
PKG_DATA_CHUNK3_DESCRIPTION="$PKG_DATA_DESCRIPTION - chunk 3"
PKG_DATA_DEPS="$PKG_DATA_DEPS $PKG_DATA_CHUNK3_ID"

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libm.so.6
libopenal.so.1
libpthread.so.0
librt.so.1'

# Ensure easy upgrade from packages generated with pre-20230410.1 game scripts

PKG_DATA_CHUNK1_PROVIDE='state-of-mind-paks-1'
PKG_DATA_CHUNK2_PROVIDE='state-of-mind-paks-2'
PKG_DATA_CHUNK3_PROVIDE='state-of-mind-paks-3'

# Load common functions

target_version='2.25'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

packages_generation

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
