#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Fossil Echo
# send your bug reports to contact@dotslashplay.it
###

script_version=20230221.4

GAME_ID='fossil-echo'
GAME_NAME='Fossil Echo'

ARCHIVE_BASE_0='FossilEcho_setup.zip'
ARCHIVE_BASE_0_MD5='079e62f826016c1d3edd35e8fe40bb3a'
ARCHIVE_BASE_0_SIZE='2900000'
ARCHIVE_BASE_0_VERSION='1.0-itch1'
ARCHIVE_BASE_0_URL='https://awaceb.itch.io/fossilecho'

CONTENT_PATH_DEFAULT='app'
CONTENT_GAME_BIN_FILES='
datatypes.dll
fmod.dll
fmodstudio.dll
fossilecho.exe'
CONTENT_GAME_DATA_FILES='
content
data
level
media'

APP_WINE_LINK_DIRS='
saves:users/${USER}/Documents/SavedGames/fossilecho/saves'
USER_PERSISTENT_DIRECTORIES='
data
saves'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE='fossilecho.exe'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"

# Install Microsoft XNA 4.0 runtime on first launch

APP_MAIN_PRERUN="$APP_MAIN_PRERUN"'

# Do not disable mscoree library
export WINEDLLOVERRIDES="winemenubuilder.exe,mshtml="

# Install Microsoft XNA 4.0 runtime on first launch
if [ ! -e xna40_installed ]; then
	winetricks_wrapper xna40
	touch xna40_installed
fi'
PKG_BIN_DEPS="$PKG_BIN_DEPS winetricks"

# Ensure required write permissions on some paths

USER_PERSISTENT_DIRECTORIES="$USER_PERSISTENT_DIRECTORIES
level"

# Load common functions

target_version='2.21'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'
INNER_ARCHIVE="${PLAYIT_WORKDIR}/gamedata/FossilEcho_setup.exe"
INNER_ARCHIVE_TYPE='innosetup'
archive_extraction 'INNER_ARCHIVE'
rm --force "$INNER_ARCHIVE"

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
