/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TracedReferenceValue;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.ValueFactory;

public class ReferenceTracingValueFactory
extends SimplifiedVisitor
implements InstructionVisitor,
ValueFactory {
    private final ValueFactory valueFactory;
    private final boolean preserveTraceValueOnCasts;
    private Value traceValue;

    public ReferenceTracingValueFactory(ValueFactory valueFactory) {
        this(valueFactory, true);
    }

    public ReferenceTracingValueFactory(ValueFactory valueFactory, boolean bl) {
        this.valueFactory = valueFactory;
        this.preserveTraceValueOnCasts = bl;
    }

    public void setTraceValue(Value value) {
        this.traceValue = value;
    }

    public TracedReferenceValue cast(TracedReferenceValue tracedReferenceValue, String string, Clazz clazz, boolean bl) {
        ReferenceValue referenceValue = tracedReferenceValue.getReferenceValue().cast(string, clazz, this.valueFactory, bl);
        return new TracedReferenceValue(referenceValue, this.preserveTraceValueOnCasts ? tracedReferenceValue.getTraceValue() : this.traceValue);
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
        this.traceValue = null;
    }

    @Override
    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SimpleInstruction simpleInstruction) {
        switch (simpleInstruction.opcode) {
            case -68: 
            case -65: 
            case 1: {
                this.traceValue = new InstructionOffsetValue(n | 0x8000000);
                break;
            }
            case 50: {
                this.traceValue = new InstructionOffsetValue(n);
                break;
            }
            default: {
                this.traceValue = null;
            }
        }
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
        switch (constantInstruction.opcode) {
            case -69: 
            case -67: 
            case -59: 
            case 18: 
            case 19: {
                this.traceValue = new InstructionOffsetValue(n | 0x8000000);
                break;
            }
            case -78: 
            case -76: {
                this.traceValue = new InstructionOffsetValue(n | 0x4000000);
                break;
            }
            case -74: 
            case -73: 
            case -72: 
            case -71: {
                this.traceValue = new InstructionOffsetValue(n | 0x2000000);
                break;
            }
            case -64: {
                this.traceValue = new InstructionOffsetValue(n | 0x10000000);
                break;
            }
            default: {
                this.traceValue = null;
            }
        }
    }

    @Override
    public Value createValue(String string, Clazz clazz, boolean bl, boolean bl2) {
        return this.trace(this.valueFactory.createValue(string, clazz, bl, bl2));
    }

    @Override
    public IntegerValue createIntegerValue() {
        return this.valueFactory.createIntegerValue();
    }

    @Override
    public IntegerValue createIntegerValue(int n) {
        return this.valueFactory.createIntegerValue(n);
    }

    @Override
    public LongValue createLongValue() {
        return this.valueFactory.createLongValue();
    }

    @Override
    public LongValue createLongValue(long l) {
        return this.valueFactory.createLongValue(l);
    }

    @Override
    public FloatValue createFloatValue() {
        return this.valueFactory.createFloatValue();
    }

    @Override
    public FloatValue createFloatValue(float f) {
        return this.valueFactory.createFloatValue(f);
    }

    @Override
    public DoubleValue createDoubleValue() {
        return this.valueFactory.createDoubleValue();
    }

    @Override
    public DoubleValue createDoubleValue(double d) {
        return this.valueFactory.createDoubleValue(d);
    }

    @Override
    public ReferenceValue createReferenceValue() {
        return this.trace(this.valueFactory.createReferenceValue());
    }

    @Override
    public ReferenceValue createReferenceValueNull() {
        return this.trace(this.valueFactory.createReferenceValueNull());
    }

    @Override
    public ReferenceValue createReferenceValue(String string, Clazz clazz, boolean bl, boolean bl2) {
        return this.trace(this.valueFactory.createReferenceValue(string, clazz, bl, bl2));
    }

    @Override
    public ReferenceValue createArrayReferenceValue(String string, Clazz clazz, IntegerValue integerValue) {
        return this.trace(this.valueFactory.createArrayReferenceValue(string, clazz, integerValue));
    }

    @Override
    public ReferenceValue createArrayReferenceValue(String string, Clazz clazz, IntegerValue integerValue, Value value) {
        return this.trace(this.valueFactory.createArrayReferenceValue(string, clazz, integerValue, value));
    }

    public Value trace(Value value) {
        return value.computationalType() == 5 ? this.trace(value.referenceValue()) : value;
    }

    public ReferenceValue trace(ReferenceValue referenceValue) {
        return this.traceValue != null ? new TracedReferenceValue(referenceValue, this.traceValue) : referenceValue;
    }
}

