This folder contains tests for MIR optimizations.

The `mir-opt` test format emits MIR to extra files that you can automatically update by specifying
`--bless` on the command line (just like `ui` tests updating `.stderr` files).

# `--bless`able test format

By default 32 bit and 64 bit targets use the same dump files, which can be problematic in the
presence of pointers in constants or other bit width dependent things. In that case you can add

```
// EMIT_MIR_FOR_EACH_BIT_WIDTH
```

to your test, causing separate files to be generated for 32bit and 64bit systems.

## Unit testing

If you are only testing the behavior of a particular mir-opt pass on some specific input (as is
usually the case), you should add

```
// unit-test: PassName
```

to the top of the file. This makes sure that other passes don't run which means you'll get the input
you expected and your test won't break when other code changes.

## Emit a diff of the mir for a specific optimization

This is what you want most often when you want to see how an optimization changes the MIR.

```
// EMIT_MIR $file_name_of_some_mir_dump.diff
```

## Emit mir after a specific optimization

Use this if you are just interested in the final state after an optimization.

```
// EMIT_MIR $file_name_of_some_mir_dump.after.mir
```

## Emit mir before a specific optimization

This exists mainly for completeness and is rarely useful.

```
// EMIT_MIR $file_name_of_some_mir_dump.before.mir
```

# FileCheck directives

The LLVM FileCheck tool is used to verify the contents of output MIR against `CHECK` directives
present in the test file. This works on the runtime MIR, generated by `--emit=mir`, and not
on the output of a individual passes.

Use `// skip-filecheck` to prevent FileCheck from running.

To check MIR for function `foo`, start with a `// CHECK-LABEL fn foo(` directive.

`{{regex}}` syntax allows to match `regex`.

`[[name:regex]]` syntax allows to bind `name` to a string matching `regex`, and refer to it
as `[[name]]` in later directives, `regex` should be written not to match a leading space.
Use `[[my_local:_.*]]` to name a local, and `[[my_bb:bb.*]]` to name a block.

Documentation for FileCheck is available here: https://www.llvm.org/docs/CommandGuide/FileCheck.html
