//! This crate contains pre-baked ICU4X data, generated by `icu4x-datagen`. The tool
//! fetches locale data from CLDR and transforms them into const code in statics that
//! ICU4X can load, via databake. `lib.rs` in this crate is manually written, but all
//! other code is generated.
//!
//! This crate can be regenerated when there's a new CLDR version, though that is unlikely
//! to result in changes in most cases (currently this only covers list formatting data, which
//! is rather stable). It may need to be regenerated when updating ICU4X versions, especially
//! across major versions, in case it fails to compile after an update.
//!
//! It must be regenerated when adding new locales to Rust, or if Rust's usage of ICU4X
//! grows to need more kinds of data.
//!
//! To regenerate the data, run this command:
//!
//! ```text
//! icu4x-datagen -W --pretty --fingerprint --use-separate-crates \
//! --format mod -l en es fr it ja pt ru tr zh zh-Hans zh-Hant \
//! -k list/and@1 fallback/likelysubtags@1 fallback/parents@1 fallback/supplement/co@1 \
//! --cldr-tag latest --icuexport-tag latest -o src/data
//! ```

#![cfg_attr(not(bootstrap), allow(internal_features))]
#![cfg_attr(not(bootstrap), feature(rustdoc_internals))]
#![cfg_attr(not(bootstrap), doc(rust_logo))]
#![allow(elided_lifetimes_in_paths)]

mod data {
    include!("data/mod.rs");
    include!("data/any.rs");
}

pub use data::BakedDataProvider;

pub const fn baked_data_provider() -> BakedDataProvider {
    data::BakedDataProvider
}

pub mod supported_locales {
    pub const EN: icu_locid::Locale = icu_locid::locale!("en");
    pub const ES: icu_locid::Locale = icu_locid::locale!("es");
    pub const FR: icu_locid::Locale = icu_locid::locale!("fr");
    pub const IT: icu_locid::Locale = icu_locid::locale!("it");
    pub const JA: icu_locid::Locale = icu_locid::locale!("ja");
    pub const PT: icu_locid::Locale = icu_locid::locale!("pt");
    pub const RU: icu_locid::Locale = icu_locid::locale!("ru");
    pub const TR: icu_locid::Locale = icu_locid::locale!("tr");
    pub const ZH_HANS: icu_locid::Locale = icu_locid::locale!("zh-Hans");
    pub const ZH_HANT: icu_locid::Locale = icu_locid::locale!("zh-Hant");
}
