#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpAddRequestHeaders(hrequest: *mut ::core::ffi::c_void, lpszheaders: &[u16], dwmodifiers: u32) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpAddRequestHeaders(hrequest: *mut ::core::ffi::c_void, lpszheaders: ::windows::core::PCWSTR, dwheaderslength: u32, dwmodifiers: u32) -> super::super::Foundation::BOOL;
    }
    WinHttpAddRequestHeaders(::core::mem::transmute(hrequest), ::core::mem::transmute(lpszheaders.as_ptr()), lpszheaders.len() as _, dwmodifiers)
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
#[inline]
pub unsafe fn WinHttpAddRequestHeadersEx(hrequest: *mut ::core::ffi::c_void, dwmodifiers: u32, ullflags: u64, ullextra: u64, pheaders: &[WINHTTP_EXTENDED_HEADER]) -> u32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpAddRequestHeadersEx(hrequest: *mut ::core::ffi::c_void, dwmodifiers: u32, ullflags: u64, ullextra: u64, cheaders: u32, pheaders: *const WINHTTP_EXTENDED_HEADER) -> u32;
    }
    WinHttpAddRequestHeadersEx(::core::mem::transmute(hrequest), dwmodifiers, ullflags, ullextra, pheaders.len() as _, ::core::mem::transmute(pheaders.as_ptr()))
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpCheckPlatform() -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpCheckPlatform() -> super::super::Foundation::BOOL;
    }
    WinHttpCheckPlatform()
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpCloseHandle(hinternet: *mut ::core::ffi::c_void) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpCloseHandle(hinternet: *mut ::core::ffi::c_void) -> super::super::Foundation::BOOL;
    }
    WinHttpCloseHandle(::core::mem::transmute(hinternet))
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
#[inline]
pub unsafe fn WinHttpConnect<'a, P0>(hsession: *mut ::core::ffi::c_void, pswzservername: P0, nserverport: INTERNET_PORT, dwreserved: u32) -> *mut ::core::ffi::c_void
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpConnect(hsession: *mut ::core::ffi::c_void, pswzservername: ::windows::core::PCWSTR, nserverport: INTERNET_PORT, dwreserved: u32) -> *mut ::core::ffi::c_void;
    }
    WinHttpConnect(::core::mem::transmute(hsession), pswzservername.into(), nserverport, dwreserved)
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpCrackUrl(pwszurl: &[u16], dwflags: u32, lpurlcomponents: *mut URL_COMPONENTS) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpCrackUrl(pwszurl: ::windows::core::PCWSTR, dwurllength: u32, dwflags: u32, lpurlcomponents: *mut URL_COMPONENTS) -> super::super::Foundation::BOOL;
    }
    WinHttpCrackUrl(::core::mem::transmute(pwszurl.as_ptr()), pwszurl.len() as _, dwflags, ::core::mem::transmute(lpurlcomponents))
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
#[inline]
pub unsafe fn WinHttpCreateProxyResolver(hsession: *const ::core::ffi::c_void, phresolver: *mut *mut ::core::ffi::c_void) -> u32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpCreateProxyResolver(hsession: *const ::core::ffi::c_void, phresolver: *mut *mut ::core::ffi::c_void) -> u32;
    }
    WinHttpCreateProxyResolver(::core::mem::transmute(hsession), ::core::mem::transmute(phresolver))
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpCreateUrl(lpurlcomponents: *const URL_COMPONENTS, dwflags: WIN_HTTP_CREATE_URL_FLAGS, pwszurl: ::windows::core::PWSTR, pdwurllength: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpCreateUrl(lpurlcomponents: *const URL_COMPONENTS, dwflags: WIN_HTTP_CREATE_URL_FLAGS, pwszurl: ::windows::core::PWSTR, pdwurllength: *mut u32) -> super::super::Foundation::BOOL;
    }
    WinHttpCreateUrl(::core::mem::transmute(lpurlcomponents), dwflags, ::core::mem::transmute(pwszurl), ::core::mem::transmute(pdwurllength))
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpDetectAutoProxyConfigUrl(dwautodetectflags: u32, ppwstrautoconfigurl: ::core::option::Option<*mut ::windows::core::PWSTR>) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpDetectAutoProxyConfigUrl(dwautodetectflags: u32, ppwstrautoconfigurl: *mut ::windows::core::PWSTR) -> super::super::Foundation::BOOL;
    }
    WinHttpDetectAutoProxyConfigUrl(dwautodetectflags, ::core::mem::transmute(ppwstrautoconfigurl.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpFreeProxyResult(pproxyresult: *mut WINHTTP_PROXY_RESULT) {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpFreeProxyResult(pproxyresult: *mut WINHTTP_PROXY_RESULT);
    }
    WinHttpFreeProxyResult(::core::mem::transmute(pproxyresult))
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpFreeProxyResultEx(pproxyresultex: *mut WINHTTP_PROXY_RESULT_EX) {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpFreeProxyResultEx(pproxyresultex: *mut WINHTTP_PROXY_RESULT_EX);
    }
    WinHttpFreeProxyResultEx(::core::mem::transmute(pproxyresultex))
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpFreeProxySettings(pwinhttpproxysettings: *const WINHTTP_PROXY_SETTINGS) {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpFreeProxySettings(pwinhttpproxysettings: *const WINHTTP_PROXY_SETTINGS);
    }
    WinHttpFreeProxySettings(::core::mem::transmute(pwinhttpproxysettings))
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
#[inline]
pub unsafe fn WinHttpFreeQueryConnectionGroupResult(presult: *mut WINHTTP_QUERY_CONNECTION_GROUP_RESULT) {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpFreeQueryConnectionGroupResult(presult: *mut WINHTTP_QUERY_CONNECTION_GROUP_RESULT);
    }
    WinHttpFreeQueryConnectionGroupResult(::core::mem::transmute(presult))
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpGetDefaultProxyConfiguration(pproxyinfo: *mut WINHTTP_PROXY_INFO) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpGetDefaultProxyConfiguration(pproxyinfo: *mut WINHTTP_PROXY_INFO) -> super::super::Foundation::BOOL;
    }
    WinHttpGetDefaultProxyConfiguration(::core::mem::transmute(pproxyinfo))
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpGetIEProxyConfigForCurrentUser(pproxyconfig: *mut WINHTTP_CURRENT_USER_IE_PROXY_CONFIG) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpGetIEProxyConfigForCurrentUser(pproxyconfig: *mut WINHTTP_CURRENT_USER_IE_PROXY_CONFIG) -> super::super::Foundation::BOOL;
    }
    WinHttpGetIEProxyConfigForCurrentUser(::core::mem::transmute(pproxyconfig))
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpGetProxyForUrl<'a, P0>(hsession: *mut ::core::ffi::c_void, lpcwszurl: P0, pautoproxyoptions: *mut WINHTTP_AUTOPROXY_OPTIONS, pproxyinfo: *mut WINHTTP_PROXY_INFO) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpGetProxyForUrl(hsession: *mut ::core::ffi::c_void, lpcwszurl: ::windows::core::PCWSTR, pautoproxyoptions: *mut WINHTTP_AUTOPROXY_OPTIONS, pproxyinfo: *mut WINHTTP_PROXY_INFO) -> super::super::Foundation::BOOL;
    }
    WinHttpGetProxyForUrl(::core::mem::transmute(hsession), lpcwszurl.into(), ::core::mem::transmute(pautoproxyoptions), ::core::mem::transmute(pproxyinfo))
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpGetProxyForUrlEx<'a, P0>(hresolver: *const ::core::ffi::c_void, pcwszurl: P0, pautoproxyoptions: *const WINHTTP_AUTOPROXY_OPTIONS, pcontext: usize) -> u32
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpGetProxyForUrlEx(hresolver: *const ::core::ffi::c_void, pcwszurl: ::windows::core::PCWSTR, pautoproxyoptions: *const WINHTTP_AUTOPROXY_OPTIONS, pcontext: usize) -> u32;
    }
    WinHttpGetProxyForUrlEx(::core::mem::transmute(hresolver), pcwszurl.into(), ::core::mem::transmute(pautoproxyoptions), pcontext)
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpGetProxyForUrlEx2<'a, P0>(hresolver: *const ::core::ffi::c_void, pcwszurl: P0, pautoproxyoptions: *const WINHTTP_AUTOPROXY_OPTIONS, pinterfaceselectioncontext: ::core::option::Option<&[u8]>, pcontext: usize) -> u32
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpGetProxyForUrlEx2(hresolver: *const ::core::ffi::c_void, pcwszurl: ::windows::core::PCWSTR, pautoproxyoptions: *const WINHTTP_AUTOPROXY_OPTIONS, cbinterfaceselectioncontext: u32, pinterfaceselectioncontext: *const u8, pcontext: usize) -> u32;
    }
    WinHttpGetProxyForUrlEx2(::core::mem::transmute(hresolver), pcwszurl.into(), ::core::mem::transmute(pautoproxyoptions), pinterfaceselectioncontext.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(pinterfaceselectioncontext.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), pcontext)
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpGetProxyResult(hresolver: *const ::core::ffi::c_void, pproxyresult: *mut WINHTTP_PROXY_RESULT) -> u32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpGetProxyResult(hresolver: *const ::core::ffi::c_void, pproxyresult: *mut WINHTTP_PROXY_RESULT) -> u32;
    }
    WinHttpGetProxyResult(::core::mem::transmute(hresolver), ::core::mem::transmute(pproxyresult))
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpGetProxyResultEx(hresolver: *const ::core::ffi::c_void, pproxyresultex: *mut WINHTTP_PROXY_RESULT_EX) -> u32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpGetProxyResultEx(hresolver: *const ::core::ffi::c_void, pproxyresultex: *mut WINHTTP_PROXY_RESULT_EX) -> u32;
    }
    WinHttpGetProxyResultEx(::core::mem::transmute(hresolver), ::core::mem::transmute(pproxyresultex))
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
#[inline]
pub unsafe fn WinHttpGetProxySettingsVersion(hsession: *const ::core::ffi::c_void, pdwproxysettingsversion: *mut u32) -> u32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpGetProxySettingsVersion(hsession: *const ::core::ffi::c_void, pdwproxysettingsversion: *mut u32) -> u32;
    }
    WinHttpGetProxySettingsVersion(::core::mem::transmute(hsession), ::core::mem::transmute(pdwproxysettingsversion))
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
#[inline]
pub unsafe fn WinHttpOpen<'a, P0, P1, P2>(pszagentw: P0, dwaccesstype: WINHTTP_ACCESS_TYPE, pszproxyw: P1, pszproxybypassw: P2, dwflags: u32) -> *mut ::core::ffi::c_void
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpOpen(pszagentw: ::windows::core::PCWSTR, dwaccesstype: WINHTTP_ACCESS_TYPE, pszproxyw: ::windows::core::PCWSTR, pszproxybypassw: ::windows::core::PCWSTR, dwflags: u32) -> *mut ::core::ffi::c_void;
    }
    WinHttpOpen(pszagentw.into(), dwaccesstype, pszproxyw.into(), pszproxybypassw.into(), dwflags)
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
#[inline]
pub unsafe fn WinHttpOpenRequest<'a, P0, P1, P2, P3>(hconnect: *mut ::core::ffi::c_void, pwszverb: P0, pwszobjectname: P1, pwszversion: P2, pwszreferrer: P3, ppwszaccepttypes: *mut ::windows::core::PWSTR, dwflags: WINHTTP_OPEN_REQUEST_FLAGS) -> *mut ::core::ffi::c_void
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
    P2: ::std::convert::Into<::windows::core::PCWSTR>,
    P3: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpOpenRequest(hconnect: *mut ::core::ffi::c_void, pwszverb: ::windows::core::PCWSTR, pwszobjectname: ::windows::core::PCWSTR, pwszversion: ::windows::core::PCWSTR, pwszreferrer: ::windows::core::PCWSTR, ppwszaccepttypes: *mut ::windows::core::PWSTR, dwflags: WINHTTP_OPEN_REQUEST_FLAGS) -> *mut ::core::ffi::c_void;
    }
    WinHttpOpenRequest(::core::mem::transmute(hconnect), pwszverb.into(), pwszobjectname.into(), pwszversion.into(), pwszreferrer.into(), ::core::mem::transmute(ppwszaccepttypes), dwflags)
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpQueryAuthSchemes(hrequest: *mut ::core::ffi::c_void, lpdwsupportedschemes: *mut u32, lpdwfirstscheme: *mut u32, pdwauthtarget: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpQueryAuthSchemes(hrequest: *mut ::core::ffi::c_void, lpdwsupportedschemes: *mut u32, lpdwfirstscheme: *mut u32, pdwauthtarget: *mut u32) -> super::super::Foundation::BOOL;
    }
    WinHttpQueryAuthSchemes(::core::mem::transmute(hrequest), ::core::mem::transmute(lpdwsupportedschemes), ::core::mem::transmute(lpdwfirstscheme), ::core::mem::transmute(pdwauthtarget))
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
#[inline]
pub unsafe fn WinHttpQueryConnectionGroup(hinternet: *const ::core::ffi::c_void, pguidconnection: ::core::option::Option<*const ::windows::core::GUID>, ullflags: u64, ppresult: *mut *mut WINHTTP_QUERY_CONNECTION_GROUP_RESULT) -> u32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpQueryConnectionGroup(hinternet: *const ::core::ffi::c_void, pguidconnection: *const ::windows::core::GUID, ullflags: u64, ppresult: *mut *mut WINHTTP_QUERY_CONNECTION_GROUP_RESULT) -> u32;
    }
    WinHttpQueryConnectionGroup(::core::mem::transmute(hinternet), ::core::mem::transmute(pguidconnection.unwrap_or(::std::ptr::null())), ullflags, ::core::mem::transmute(ppresult))
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpQueryDataAvailable(hrequest: *mut ::core::ffi::c_void, lpdwnumberofbytesavailable: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpQueryDataAvailable(hrequest: *mut ::core::ffi::c_void, lpdwnumberofbytesavailable: *mut u32) -> super::super::Foundation::BOOL;
    }
    WinHttpQueryDataAvailable(::core::mem::transmute(hrequest), ::core::mem::transmute(lpdwnumberofbytesavailable))
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpQueryHeaders<'a, P0>(hrequest: *mut ::core::ffi::c_void, dwinfolevel: u32, pwszname: P0, lpbuffer: ::core::option::Option<*mut ::core::ffi::c_void>, lpdwbufferlength: *mut u32, lpdwindex: *mut u32) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpQueryHeaders(hrequest: *mut ::core::ffi::c_void, dwinfolevel: u32, pwszname: ::windows::core::PCWSTR, lpbuffer: *mut ::core::ffi::c_void, lpdwbufferlength: *mut u32, lpdwindex: *mut u32) -> super::super::Foundation::BOOL;
    }
    WinHttpQueryHeaders(::core::mem::transmute(hrequest), dwinfolevel, pwszname.into(), ::core::mem::transmute(lpbuffer.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(lpdwbufferlength), ::core::mem::transmute(lpdwindex))
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
#[inline]
pub unsafe fn WinHttpQueryHeadersEx(hrequest: *const ::core::ffi::c_void, dwinfolevel: u32, ullflags: u64, uicodepage: u32, pdwindex: ::core::option::Option<*mut u32>, pheadername: ::core::option::Option<*const WINHTTP_HEADER_NAME>, pbuffer: ::core::option::Option<*mut ::core::ffi::c_void>, pdwbufferlength: *mut u32, ppheaders: ::core::option::Option<*mut *mut WINHTTP_EXTENDED_HEADER>, pdwheaderscount: *mut u32) -> u32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpQueryHeadersEx(hrequest: *const ::core::ffi::c_void, dwinfolevel: u32, ullflags: u64, uicodepage: u32, pdwindex: *mut u32, pheadername: *const WINHTTP_HEADER_NAME, pbuffer: *mut ::core::ffi::c_void, pdwbufferlength: *mut u32, ppheaders: *mut *mut WINHTTP_EXTENDED_HEADER, pdwheaderscount: *mut u32) -> u32;
    }
    WinHttpQueryHeadersEx(::core::mem::transmute(hrequest), dwinfolevel, ullflags, uicodepage, ::core::mem::transmute(pdwindex.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pheadername.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pbuffer.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pdwbufferlength), ::core::mem::transmute(ppheaders.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pdwheaderscount))
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpQueryOption(hinternet: *mut ::core::ffi::c_void, dwoption: u32, lpbuffer: ::core::option::Option<*mut ::core::ffi::c_void>, lpdwbufferlength: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpQueryOption(hinternet: *mut ::core::ffi::c_void, dwoption: u32, lpbuffer: *mut ::core::ffi::c_void, lpdwbufferlength: *mut u32) -> super::super::Foundation::BOOL;
    }
    WinHttpQueryOption(::core::mem::transmute(hinternet), dwoption, ::core::mem::transmute(lpbuffer.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(lpdwbufferlength))
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpReadData(hrequest: *mut ::core::ffi::c_void, lpbuffer: *mut ::core::ffi::c_void, dwnumberofbytestoread: u32, lpdwnumberofbytesread: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpReadData(hrequest: *mut ::core::ffi::c_void, lpbuffer: *mut ::core::ffi::c_void, dwnumberofbytestoread: u32, lpdwnumberofbytesread: *mut u32) -> super::super::Foundation::BOOL;
    }
    WinHttpReadData(::core::mem::transmute(hrequest), ::core::mem::transmute(lpbuffer), dwnumberofbytestoread, ::core::mem::transmute(lpdwnumberofbytesread))
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
#[inline]
pub unsafe fn WinHttpReadDataEx(hrequest: *mut ::core::ffi::c_void, lpbuffer: *mut ::core::ffi::c_void, dwnumberofbytestoread: u32, lpdwnumberofbytesread: *mut u32, ullflags: u64, cbproperty: u32, pvproperty: ::core::option::Option<*const ::core::ffi::c_void>) -> u32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpReadDataEx(hrequest: *mut ::core::ffi::c_void, lpbuffer: *mut ::core::ffi::c_void, dwnumberofbytestoread: u32, lpdwnumberofbytesread: *mut u32, ullflags: u64, cbproperty: u32, pvproperty: *const ::core::ffi::c_void) -> u32;
    }
    WinHttpReadDataEx(::core::mem::transmute(hrequest), ::core::mem::transmute(lpbuffer), dwnumberofbytestoread, ::core::mem::transmute(lpdwnumberofbytesread), ullflags, cbproperty, ::core::mem::transmute(pvproperty.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpReadProxySettings<'a, P0, P1, P2>(hsession: *const ::core::ffi::c_void, pcwszconnectionname: P0, ffallbacktodefaultsettings: P1, fsetautodiscoverfordefaultsettings: P2, pdwsettingsversion: *mut u32, pfdefaultsettingsarereturned: *mut super::super::Foundation::BOOL, pwinhttpproxysettings: *mut WINHTTP_PROXY_SETTINGS) -> u32
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<super::super::Foundation::BOOL>,
    P2: ::std::convert::Into<super::super::Foundation::BOOL>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpReadProxySettings(hsession: *const ::core::ffi::c_void, pcwszconnectionname: ::windows::core::PCWSTR, ffallbacktodefaultsettings: super::super::Foundation::BOOL, fsetautodiscoverfordefaultsettings: super::super::Foundation::BOOL, pdwsettingsversion: *mut u32, pfdefaultsettingsarereturned: *mut super::super::Foundation::BOOL, pwinhttpproxysettings: *mut WINHTTP_PROXY_SETTINGS) -> u32;
    }
    WinHttpReadProxySettings(::core::mem::transmute(hsession), pcwszconnectionname.into(), ffallbacktodefaultsettings.into(), fsetautodiscoverfordefaultsettings.into(), ::core::mem::transmute(pdwsettingsversion), ::core::mem::transmute(pfdefaultsettingsarereturned), ::core::mem::transmute(pwinhttpproxysettings))
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpReceiveResponse(hrequest: *mut ::core::ffi::c_void, lpreserved: *mut ::core::ffi::c_void) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpReceiveResponse(hrequest: *mut ::core::ffi::c_void, lpreserved: *mut ::core::ffi::c_void) -> super::super::Foundation::BOOL;
    }
    WinHttpReceiveResponse(::core::mem::transmute(hrequest), ::core::mem::transmute(lpreserved))
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
#[inline]
pub unsafe fn WinHttpResetAutoProxy(hsession: *const ::core::ffi::c_void, dwflags: u32) -> u32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpResetAutoProxy(hsession: *const ::core::ffi::c_void, dwflags: u32) -> u32;
    }
    WinHttpResetAutoProxy(::core::mem::transmute(hsession), dwflags)
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpSendRequest(hrequest: *mut ::core::ffi::c_void, lpszheaders: ::core::option::Option<&[u16]>, lpoptional: ::core::option::Option<*const ::core::ffi::c_void>, dwoptionallength: u32, dwtotallength: u32, dwcontext: usize) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpSendRequest(hrequest: *mut ::core::ffi::c_void, lpszheaders: ::windows::core::PCWSTR, dwheaderslength: u32, lpoptional: *const ::core::ffi::c_void, dwoptionallength: u32, dwtotallength: u32, dwcontext: usize) -> super::super::Foundation::BOOL;
    }
    WinHttpSendRequest(::core::mem::transmute(hrequest), ::core::mem::transmute(lpszheaders.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), lpszheaders.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(lpoptional.unwrap_or(::std::ptr::null())), dwoptionallength, dwtotallength, dwcontext)
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpSetCredentials<'a, P0, P1>(hrequest: *mut ::core::ffi::c_void, authtargets: u32, authscheme: u32, pwszusername: P0, pwszpassword: P1, pauthparams: *mut ::core::ffi::c_void) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
    P1: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpSetCredentials(hrequest: *mut ::core::ffi::c_void, authtargets: u32, authscheme: u32, pwszusername: ::windows::core::PCWSTR, pwszpassword: ::windows::core::PCWSTR, pauthparams: *mut ::core::ffi::c_void) -> super::super::Foundation::BOOL;
    }
    WinHttpSetCredentials(::core::mem::transmute(hrequest), authtargets, authscheme, pwszusername.into(), pwszpassword.into(), ::core::mem::transmute(pauthparams))
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpSetDefaultProxyConfiguration(pproxyinfo: *mut WINHTTP_PROXY_INFO) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpSetDefaultProxyConfiguration(pproxyinfo: *mut WINHTTP_PROXY_INFO) -> super::super::Foundation::BOOL;
    }
    WinHttpSetDefaultProxyConfiguration(::core::mem::transmute(pproxyinfo))
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpSetOption(hinternet: ::core::option::Option<*const ::core::ffi::c_void>, dwoption: u32, lpbuffer: ::core::option::Option<&[u8]>) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpSetOption(hinternet: *const ::core::ffi::c_void, dwoption: u32, lpbuffer: *const ::core::ffi::c_void, dwbufferlength: u32) -> super::super::Foundation::BOOL;
    }
    WinHttpSetOption(::core::mem::transmute(hinternet.unwrap_or(::std::ptr::null())), dwoption, ::core::mem::transmute(lpbuffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), lpbuffer.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpSetProxySettingsPerUser<'a, P0>(fproxysettingsperuser: P0) -> u32
where
    P0: ::std::convert::Into<super::super::Foundation::BOOL>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpSetProxySettingsPerUser(fproxysettingsperuser: super::super::Foundation::BOOL) -> u32;
    }
    WinHttpSetProxySettingsPerUser(fproxysettingsperuser.into())
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
#[inline]
pub unsafe fn WinHttpSetStatusCallback(hinternet: *mut ::core::ffi::c_void, lpfninternetcallback: WINHTTP_STATUS_CALLBACK, dwnotificationflags: u32, dwreserved: usize) -> WINHTTP_STATUS_CALLBACK {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpSetStatusCallback(hinternet: *mut ::core::ffi::c_void, lpfninternetcallback: *mut ::core::ffi::c_void, dwnotificationflags: u32, dwreserved: usize) -> WINHTTP_STATUS_CALLBACK;
    }
    WinHttpSetStatusCallback(::core::mem::transmute(hinternet), ::core::mem::transmute(lpfninternetcallback), dwnotificationflags, dwreserved)
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpSetTimeouts(hinternet: *mut ::core::ffi::c_void, nresolvetimeout: i32, nconnecttimeout: i32, nsendtimeout: i32, nreceivetimeout: i32) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpSetTimeouts(hinternet: *mut ::core::ffi::c_void, nresolvetimeout: i32, nconnecttimeout: i32, nsendtimeout: i32, nreceivetimeout: i32) -> super::super::Foundation::BOOL;
    }
    WinHttpSetTimeouts(::core::mem::transmute(hinternet), nresolvetimeout, nconnecttimeout, nsendtimeout, nreceivetimeout)
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpTimeFromSystemTime(pst: *const super::super::Foundation::SYSTEMTIME, pwsztime: &mut [u16; 62]) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpTimeFromSystemTime(pst: *const super::super::Foundation::SYSTEMTIME, pwsztime: ::windows::core::PWSTR) -> super::super::Foundation::BOOL;
    }
    WinHttpTimeFromSystemTime(::core::mem::transmute(pst), ::core::mem::transmute(pwsztime.as_ptr()))
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpTimeToSystemTime<'a, P0>(pwsztime: P0, pst: *mut super::super::Foundation::SYSTEMTIME) -> super::super::Foundation::BOOL
where
    P0: ::std::convert::Into<::windows::core::PCWSTR>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpTimeToSystemTime(pwsztime: ::windows::core::PCWSTR, pst: *mut super::super::Foundation::SYSTEMTIME) -> super::super::Foundation::BOOL;
    }
    WinHttpTimeToSystemTime(pwsztime.into(), ::core::mem::transmute(pst))
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
#[inline]
pub unsafe fn WinHttpWebSocketClose(hwebsocket: *const ::core::ffi::c_void, usstatus: u16, pvreason: ::core::option::Option<*const ::core::ffi::c_void>, dwreasonlength: u32) -> u32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpWebSocketClose(hwebsocket: *const ::core::ffi::c_void, usstatus: u16, pvreason: *const ::core::ffi::c_void, dwreasonlength: u32) -> u32;
    }
    WinHttpWebSocketClose(::core::mem::transmute(hwebsocket), usstatus, ::core::mem::transmute(pvreason.unwrap_or(::std::ptr::null())), dwreasonlength)
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
#[inline]
pub unsafe fn WinHttpWebSocketCompleteUpgrade(hrequest: *const ::core::ffi::c_void, pcontext: usize) -> *mut ::core::ffi::c_void {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpWebSocketCompleteUpgrade(hrequest: *const ::core::ffi::c_void, pcontext: usize) -> *mut ::core::ffi::c_void;
    }
    WinHttpWebSocketCompleteUpgrade(::core::mem::transmute(hrequest), pcontext)
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
#[inline]
pub unsafe fn WinHttpWebSocketQueryCloseStatus(hwebsocket: *const ::core::ffi::c_void, pusstatus: *mut u16, pvreason: ::core::option::Option<*mut ::core::ffi::c_void>, dwreasonlength: u32, pdwreasonlengthconsumed: *mut u32) -> u32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpWebSocketQueryCloseStatus(hwebsocket: *const ::core::ffi::c_void, pusstatus: *mut u16, pvreason: *mut ::core::ffi::c_void, dwreasonlength: u32, pdwreasonlengthconsumed: *mut u32) -> u32;
    }
    WinHttpWebSocketQueryCloseStatus(::core::mem::transmute(hwebsocket), ::core::mem::transmute(pusstatus), ::core::mem::transmute(pvreason.unwrap_or(::std::ptr::null_mut())), dwreasonlength, ::core::mem::transmute(pdwreasonlengthconsumed))
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
#[inline]
pub unsafe fn WinHttpWebSocketReceive(hwebsocket: *const ::core::ffi::c_void, pvbuffer: *mut ::core::ffi::c_void, dwbufferlength: u32, pdwbytesread: *mut u32, pebuffertype: *mut WINHTTP_WEB_SOCKET_BUFFER_TYPE) -> u32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpWebSocketReceive(hwebsocket: *const ::core::ffi::c_void, pvbuffer: *mut ::core::ffi::c_void, dwbufferlength: u32, pdwbytesread: *mut u32, pebuffertype: *mut WINHTTP_WEB_SOCKET_BUFFER_TYPE) -> u32;
    }
    WinHttpWebSocketReceive(::core::mem::transmute(hwebsocket), ::core::mem::transmute(pvbuffer), dwbufferlength, ::core::mem::transmute(pdwbytesread), ::core::mem::transmute(pebuffertype))
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
#[inline]
pub unsafe fn WinHttpWebSocketSend(hwebsocket: *const ::core::ffi::c_void, ebuffertype: WINHTTP_WEB_SOCKET_BUFFER_TYPE, pvbuffer: ::core::option::Option<&[u8]>) -> u32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpWebSocketSend(hwebsocket: *const ::core::ffi::c_void, ebuffertype: WINHTTP_WEB_SOCKET_BUFFER_TYPE, pvbuffer: *const ::core::ffi::c_void, dwbufferlength: u32) -> u32;
    }
    WinHttpWebSocketSend(::core::mem::transmute(hwebsocket), ebuffertype, ::core::mem::transmute(pvbuffer.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), pvbuffer.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
#[inline]
pub unsafe fn WinHttpWebSocketShutdown(hwebsocket: *const ::core::ffi::c_void, usstatus: u16, pvreason: ::core::option::Option<*const ::core::ffi::c_void>, dwreasonlength: u32) -> u32 {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpWebSocketShutdown(hwebsocket: *const ::core::ffi::c_void, usstatus: u16, pvreason: *const ::core::ffi::c_void, dwreasonlength: u32) -> u32;
    }
    WinHttpWebSocketShutdown(::core::mem::transmute(hwebsocket), usstatus, ::core::mem::transmute(pvreason.unwrap_or(::std::ptr::null())), dwreasonlength)
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpWriteData(hrequest: *mut ::core::ffi::c_void, lpbuffer: ::core::option::Option<*const ::core::ffi::c_void>, dwnumberofbytestowrite: u32, lpdwnumberofbyteswritten: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpWriteData(hrequest: *mut ::core::ffi::c_void, lpbuffer: *const ::core::ffi::c_void, dwnumberofbytestowrite: u32, lpdwnumberofbyteswritten: *mut u32) -> super::super::Foundation::BOOL;
    }
    WinHttpWriteData(::core::mem::transmute(hrequest), ::core::mem::transmute(lpbuffer.unwrap_or(::std::ptr::null())), dwnumberofbytestowrite, ::core::mem::transmute(lpdwnumberofbyteswritten))
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn WinHttpWriteProxySettings<'a, P0>(hsession: *const ::core::ffi::c_void, fforceupdate: P0, pwinhttpproxysettings: *const WINHTTP_PROXY_SETTINGS) -> u32
where
    P0: ::std::convert::Into<super::super::Foundation::BOOL>,
{
    #[cfg_attr(windows, link(name = "windows"))]
    extern "system" {
        fn WinHttpWriteProxySettings(hsession: *const ::core::ffi::c_void, fforceupdate: super::super::Foundation::BOOL, pwinhttpproxysettings: *const WINHTTP_PROXY_SETTINGS) -> u32;
    }
    WinHttpWriteProxySettings(::core::mem::transmute(hsession), fforceupdate.into(), ::core::mem::transmute(pwinhttpproxysettings))
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const API_GET_PROXY_FOR_URL: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const API_QUERY_DATA_AVAILABLE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const API_READ_DATA: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const API_RECEIVE_RESPONSE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const API_SEND_REQUEST: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const API_WRITE_DATA: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_AUTODETECTION_FAILED: u32 = 12180u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_AUTO_PROXY_SERVICE_ERROR: u32 = 12178u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_BAD_AUTO_PROXY_SCRIPT: u32 = 12166u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_CANNOT_CALL_AFTER_OPEN: u32 = 12103u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_CANNOT_CALL_AFTER_SEND: u32 = 12102u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_CANNOT_CALL_BEFORE_OPEN: u32 = 12100u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_CANNOT_CALL_BEFORE_SEND: u32 = 12101u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_CANNOT_CONNECT: u32 = 12029u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_CHUNKED_ENCODING_HEADER_SIZE_OVERFLOW: u32 = 12183u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_CLIENT_AUTH_CERT_NEEDED: u32 = 12044u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_CLIENT_AUTH_CERT_NEEDED_PROXY: u32 = 12187u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_CLIENT_CERT_NO_ACCESS_PRIVATE_KEY: u32 = 12186u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_CLIENT_CERT_NO_PRIVATE_KEY: u32 = 12185u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_CONNECTION_ERROR: u32 = 12030u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_FEATURE_DISABLED: u32 = 12192u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_GLOBAL_CALLBACK_FAILED: u32 = 12191u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_HEADER_ALREADY_EXISTS: u32 = 12155u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_HEADER_COUNT_EXCEEDED: u32 = 12181u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_HEADER_NOT_FOUND: u32 = 12150u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_HEADER_SIZE_OVERFLOW: u32 = 12182u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_HTTP_PROTOCOL_MISMATCH: u32 = 12190u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_INCORRECT_HANDLE_STATE: u32 = 12019u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_INCORRECT_HANDLE_TYPE: u32 = 12018u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_INTERNAL_ERROR: u32 = 12004u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_INVALID_HEADER: u32 = 12153u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_INVALID_OPTION: u32 = 12009u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_INVALID_QUERY_REQUEST: u32 = 12154u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_INVALID_SERVER_RESPONSE: u32 = 12152u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_INVALID_URL: u32 = 12005u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_LOGIN_FAILURE: u32 = 12015u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_NAME_NOT_RESOLVED: u32 = 12007u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_NOT_INITIALIZED: u32 = 12172u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_OPERATION_CANCELLED: u32 = 12017u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_OPTION_NOT_SETTABLE: u32 = 12011u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_OUT_OF_HANDLES: u32 = 12001u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_REDIRECT_FAILED: u32 = 12156u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_RESEND_REQUEST: u32 = 12032u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_RESERVED_189: u32 = 12189u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_RESPONSE_DRAIN_OVERFLOW: u32 = 12184u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_SCRIPT_EXECUTION_ERROR: u32 = 12177u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_SECURE_CERT_CN_INVALID: u32 = 12038u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_SECURE_CERT_DATE_INVALID: u32 = 12037u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_SECURE_CERT_REVOKED: u32 = 12170u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_SECURE_CERT_REV_FAILED: u32 = 12057u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_SECURE_CERT_WRONG_USAGE: u32 = 12179u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_SECURE_CHANNEL_ERROR: u32 = 12157u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_SECURE_FAILURE: u32 = 12175u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_SECURE_FAILURE_PROXY: u32 = 12188u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_SECURE_INVALID_CA: u32 = 12045u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_SECURE_INVALID_CERT: u32 = 12169u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_SHUTDOWN: u32 = 12012u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_TIMEOUT: u32 = 12002u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_UNABLE_TO_DOWNLOAD_SCRIPT: u32 = 12167u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_UNHANDLED_SCRIPT_TYPE: u32 = 12176u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ERROR_WINHTTP_UNRECOGNIZED_SCHEME: u32 = 12006u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_ACCEPTED: u32 = 202u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_AMBIGUOUS: u32 = 300u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_BAD_GATEWAY: u32 = 502u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_BAD_METHOD: u32 = 405u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_BAD_REQUEST: u32 = 400u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_CONFLICT: u32 = 409u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_CONTINUE: u32 = 100u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_CREATED: u32 = 201u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_DENIED: u32 = 401u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_FIRST: u32 = 100u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_FORBIDDEN: u32 = 403u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_GATEWAY_TIMEOUT: u32 = 504u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_GONE: u32 = 410u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_LAST: u32 = 505u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_LENGTH_REQUIRED: u32 = 411u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_MOVED: u32 = 301u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_NONE_ACCEPTABLE: u32 = 406u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_NOT_FOUND: u32 = 404u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_NOT_MODIFIED: u32 = 304u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_NOT_SUPPORTED: u32 = 501u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_NO_CONTENT: u32 = 204u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_OK: u32 = 200u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_PARTIAL: u32 = 203u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_PARTIAL_CONTENT: u32 = 206u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_PAYMENT_REQ: u32 = 402u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_PERMANENT_REDIRECT: u32 = 308u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_PRECOND_FAILED: u32 = 412u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_PROXY_AUTH_REQ: u32 = 407u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_REDIRECT: u32 = 302u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_REDIRECT_KEEP_VERB: u32 = 307u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_REDIRECT_METHOD: u32 = 303u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_REQUEST_TIMEOUT: u32 = 408u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_REQUEST_TOO_LARGE: u32 = 413u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_RESET_CONTENT: u32 = 205u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_RETRY_WITH: u32 = 449u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_SERVER_ERROR: u32 = 500u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_SERVICE_UNAVAIL: u32 = 503u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_SWITCH_PROTOCOLS: u32 = 101u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_UNSUPPORTED_MEDIA: u32 = 415u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_URI_TOO_LONG: u32 = 414u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_USE_PROXY: u32 = 305u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_VERSION_NOT_SUP: u32 = 505u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const HTTP_STATUS_WEBDAV_MULTI_STATUS: u32 = 207u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ICU_BROWSER_MODE: u32 = 33554432u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ICU_ENCODE_PERCENT: u32 = 4096u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ICU_ENCODE_SPACES_ONLY: u32 = 67108864u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ICU_ESCAPE_AUTHORITY: u32 = 8192u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ICU_NO_ENCODE: u32 = 536870912u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ICU_NO_META: u32 = 134217728u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const NETWORKING_KEY_BUFSIZE: u32 = 128u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const SECURITY_FLAG_IGNORE_CERT_CN_INVALID: u32 = 4096u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const SECURITY_FLAG_IGNORE_CERT_DATE_INVALID: u32 = 8192u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const SECURITY_FLAG_IGNORE_CERT_WRONG_USAGE: u32 = 512u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const SECURITY_FLAG_IGNORE_UNKNOWN_CA: u32 = 256u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const SECURITY_FLAG_SECURE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const SECURITY_FLAG_STRENGTH_MEDIUM: u32 = 1073741824u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const SECURITY_FLAG_STRENGTH_STRONG: u32 = 536870912u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const SECURITY_FLAG_STRENGTH_WEAK: u32 = 268435456u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_ADDREQ_FLAGS_MASK: u32 = 4294901760u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_ADDREQ_FLAG_ADD: u32 = 536870912u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_ADDREQ_FLAG_ADD_IF_NEW: u32 = 268435456u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_ADDREQ_FLAG_COALESCE: u32 = 1073741824u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_ADDREQ_FLAG_COALESCE_WITH_COMMA: u32 = 1073741824u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_ADDREQ_FLAG_COALESCE_WITH_SEMICOLON: u32 = 16777216u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_ADDREQ_FLAG_REPLACE: u32 = 2147483648u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_ADDREQ_INDEX_MASK: u32 = 65535u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_AUTH_SCHEME_DIGEST: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_AUTH_SCHEME_PASSPORT: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_AUTH_TARGET_PROXY: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_AUTH_TARGET_SERVER: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_AUTOLOGON_SECURITY_LEVEL_DEFAULT: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_AUTOLOGON_SECURITY_LEVEL_HIGH: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_AUTOLOGON_SECURITY_LEVEL_LOW: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_AUTOLOGON_SECURITY_LEVEL_MEDIUM: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_AUTOPROXY_ALLOW_AUTOCONFIG: u32 = 256u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_AUTOPROXY_ALLOW_CM: u32 = 1024u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_AUTOPROXY_ALLOW_STATIC: u32 = 512u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_AUTOPROXY_AUTO_DETECT: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_AUTOPROXY_CONFIG_URL: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_AUTOPROXY_HOST_KEEPCASE: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_AUTOPROXY_HOST_LOWERCASE: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_AUTOPROXY_NO_CACHE_CLIENT: u32 = 524288u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_AUTOPROXY_NO_CACHE_SVC: u32 = 1048576u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_AUTOPROXY_NO_DIRECTACCESS: u32 = 262144u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_AUTOPROXY_RUN_INPROCESS: u32 = 65536u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_AUTOPROXY_RUN_OUTPROCESS_ONLY: u32 = 131072u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_AUTOPROXY_SORT_RESULTS: u32 = 4194304u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_AUTO_DETECT_TYPE_DHCP: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_AUTO_DETECT_TYPE_DNS_A: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_FLAG_ALL_NOTIFICATIONS: u32 = 4294967295u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_FLAG_DATA_AVAILABLE: u32 = 262144u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_FLAG_DETECTING_PROXY: u32 = 4096u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_FLAG_GETPROXYFORURL_COMPLETE: u32 = 16777216u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_FLAG_HEADERS_AVAILABLE: u32 = 131072u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_FLAG_INTERMEDIATE_RESPONSE: u32 = 32768u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_FLAG_READ_COMPLETE: u32 = 524288u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_FLAG_REDIRECT: u32 = 16384u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_FLAG_REQUEST_ERROR: u32 = 2097152u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_FLAG_SECURE_FAILURE: u32 = 65536u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_FLAG_SENDREQUEST_COMPLETE: u32 = 4194304u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_FLAG_WRITE_COMPLETE: u32 = 1048576u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_STATUS_CLOSE_COMPLETE: u32 = 33554432u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_STATUS_CLOSING_CONNECTION: u32 = 256u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_STATUS_CONNECTED_TO_SERVER: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_STATUS_CONNECTING_TO_SERVER: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_STATUS_CONNECTION_CLOSED: u32 = 512u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_STATUS_DATA_AVAILABLE: u32 = 262144u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_STATUS_DETECTING_PROXY: u32 = 4096u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_STATUS_FLAG_CERT_CN_INVALID: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_STATUS_FLAG_CERT_DATE_INVALID: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_STATUS_FLAG_CERT_REVOKED: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_STATUS_FLAG_CERT_REV_FAILED: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_STATUS_FLAG_CERT_WRONG_USAGE: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_STATUS_FLAG_INVALID_CA: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_STATUS_FLAG_INVALID_CERT: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_STATUS_FLAG_SECURITY_CHANNEL_ERROR: u32 = 2147483648u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_STATUS_GETPROXYFORURL_COMPLETE: u32 = 16777216u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_STATUS_HANDLE_CLOSING: u32 = 2048u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_STATUS_HANDLE_CREATED: u32 = 1024u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_STATUS_HEADERS_AVAILABLE: u32 = 131072u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_STATUS_INTERMEDIATE_RESPONSE: u32 = 32768u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_STATUS_NAME_RESOLVED: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_STATUS_READ_COMPLETE: u32 = 524288u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_STATUS_RECEIVING_RESPONSE: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_STATUS_REDIRECT: u32 = 16384u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_STATUS_REQUEST_ERROR: u32 = 2097152u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_STATUS_REQUEST_SENT: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_STATUS_RESOLVING_NAME: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_STATUS_RESPONSE_RECEIVED: u32 = 128u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_STATUS_SECURE_FAILURE: u32 = 65536u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_STATUS_SENDING_REQUEST: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_STATUS_SENDREQUEST_COMPLETE: u32 = 4194304u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_STATUS_SETTINGS_READ_COMPLETE: u32 = 536870912u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_STATUS_SETTINGS_WRITE_COMPLETE: u32 = 268435456u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_STATUS_SHUTDOWN_COMPLETE: u32 = 67108864u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CALLBACK_STATUS_WRITE_COMPLETE: u32 = 1048576u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CONNECTION_RETRY_CONDITION_408: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CONNECTION_RETRY_CONDITION_SSL_HANDSHAKE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CONNECTION_RETRY_CONDITION_STALE_CONNECTION: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_CONNS_PER_SERVER_UNLIMITED: u32 = 4294967295u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_DECOMPRESSION_FLAG_DEFLATE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_DECOMPRESSION_FLAG_GZIP: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_DISABLE_AUTHENTICATION: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_DISABLE_COOKIES: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_DISABLE_KEEP_ALIVE: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_DISABLE_PASSPORT_AUTH: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_DISABLE_PASSPORT_KEYRING: u32 = 536870912u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_DISABLE_REDIRECTS: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_DISABLE_SPN_SERVER_PORT: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_ENABLE_PASSPORT_AUTH: u32 = 268435456u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_ENABLE_PASSPORT_KEYRING: u32 = 1073741824u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_ENABLE_SPN_SERVER_PORT: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_ENABLE_SSL_REVERT_IMPERSONATION: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_ENABLE_SSL_REVOCATION: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_ERROR_BASE: u32 = 12000u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_ERROR_LAST: u32 = 12192u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_EXTENDED_HEADER_FLAG_UNICODE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_FLAG_ASYNC: u32 = 268435456u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_FLAG_SECURE_DEFAULTS: u32 = 805306368u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_FLAG_SECURE_PROTOCOL_SSL2: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_FLAG_SECURE_PROTOCOL_SSL3: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_FLAG_SECURE_PROTOCOL_TLS1: u32 = 128u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_FLAG_SECURE_PROTOCOL_TLS1_1: u32 = 512u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_FLAG_SECURE_PROTOCOL_TLS1_2: u32 = 2048u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_FLAG_SECURE_PROTOCOL_TLS1_3: u32 = 8192u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_HANDLE_TYPE_CONNECT: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_HANDLE_TYPE_REQUEST: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_HANDLE_TYPE_SESSION: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_IGNORE_REQUEST_TOTAL_LENGTH: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_LAST_OPTION: u32 = 183u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_MATCH_CONNECTION_GUID_FLAGS_MASK: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_MATCH_CONNECTION_GUID_FLAG_REQUIRE_MARKED_CONNECTION: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_AGGREGATE_PROXY_CONFIG: u32 = 181u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_ASSURED_NON_BLOCKING_CALLBACKS: u32 = 111u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_AUTOLOGON_POLICY: u32 = 77u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_BACKGROUND_CONNECTIONS: u32 = 172u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_CALLBACK: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_CLIENT_CERT_CONTEXT: u32 = 47u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_CLIENT_CERT_ISSUER_LIST: u32 = 94u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_CODEPAGE: u32 = 68u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_CONFIGURE_PASSPORT_AUTH: u32 = 83u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_CONNECTION_FILTER: u32 = 131u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_CONNECTION_GUID: u32 = 178u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_CONNECTION_INFO: u32 = 93u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_CONNECTION_STATS_V0: u32 = 141u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_CONNECTION_STATS_V1: u32 = 150u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_CONNECT_RETRIES: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_CONNECT_TIMEOUT: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_CONTEXT_VALUE: u32 = 45u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_DECOMPRESSION: u32 = 118u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_DISABLE_CERT_CHAIN_BUILDING: u32 = 171u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_DISABLE_FEATURE: u32 = 63u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_DISABLE_PROXY_LINK_LOCAL_NAME_RESOLUTION: u32 = 176u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_DISABLE_SECURE_PROTOCOL_FALLBACK: u32 = 144u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_DISABLE_STREAM_QUEUE: u32 = 139u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_ENABLETRACING: u32 = 85u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_ENABLE_FEATURE: u32 = 79u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_ENABLE_HTTP2_PLUS_CLIENT_CERT: u32 = 161u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_ENABLE_HTTP_PROTOCOL: u32 = 133u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_ENABLE_TEST_SIGNING: u32 = 174u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_ENCODE_EXTRA: u32 = 138u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_EXPIRE_CONNECTION: u32 = 143u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_EXTENDED_ERROR: u32 = 24u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_FAILED_CONNECTION_RETRIES: u32 = 162u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_FIRST_AVAILABLE_CONNECTION: u32 = 173u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_GLOBAL_PROXY_CREDS: u32 = 97u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_GLOBAL_SERVER_CREDS: u32 = 98u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_HANDLE_TYPE: u32 = 9u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_HEAP_EXTENSION: u32 = 157u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_HTTP2_KEEPALIVE: u32 = 164u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_HTTP2_PLUS_TRANSFER_ENCODING: u32 = 169u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_HTTP2_RECEIVE_WINDOW: u32 = 183u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_HTTP_PROTOCOL_REQUIRED: u32 = 145u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_HTTP_PROTOCOL_USED: u32 = 134u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_HTTP_VERSION: u32 = 59u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_IGNORE_CERT_REVOCATION_OFFLINE: u32 = 155u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_IPV6_FAST_FALLBACK: u32 = 140u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_IS_PROXY_CONNECT_RESPONSE: u32 = 104u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_KDC_PROXY_SETTINGS: u32 = 136u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_MATCH_CONNECTION_GUID: u32 = 179u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_MAX_CONNS_PER_1_0_SERVER: u32 = 74u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_MAX_CONNS_PER_SERVER: u32 = 73u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_MAX_HTTP_AUTOMATIC_REDIRECTS: u32 = 89u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_MAX_HTTP_STATUS_CONTINUE: u32 = 90u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_MAX_RESPONSE_DRAIN_SIZE: u32 = 92u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_MAX_RESPONSE_HEADER_SIZE: u32 = 91u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_NTSERVICE_FLAG_TEST: u32 = 175u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_PARENT_HANDLE: u32 = 21u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_PASSPORT_COBRANDING_TEXT: u32 = 81u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_PASSPORT_COBRANDING_URL: u32 = 82u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_PASSPORT_RETURN_URL: u32 = 87u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_PASSPORT_SIGN_OUT: u32 = 86u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_PASSWORD: u32 = 4097u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_PROXY: u32 = 38u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_PROXY_CONFIG_INFO: u32 = 180u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_PROXY_DISABLE_SERVICE_CALLS: u32 = 137u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_PROXY_PASSWORD: u32 = 4099u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_PROXY_RESULT_ENTRY: u32 = 39u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_PROXY_SPN_USED: u32 = 107u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_PROXY_USERNAME: u32 = 4098u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_READ_BUFFER_SIZE: u32 = 12u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_RECEIVE_PROXY_CONNECT_RESPONSE: u32 = 103u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_RECEIVE_RESPONSE_TIMEOUT: u32 = 7u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_RECEIVE_TIMEOUT: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_REDIRECT_POLICY: u32 = 88u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_REDIRECT_POLICY_ALWAYS: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_REDIRECT_POLICY_DEFAULT: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_REDIRECT_POLICY_DISALLOW_HTTPS_TO_HTTP: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_REDIRECT_POLICY_LAST: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_REDIRECT_POLICY_NEVER: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_REFERER_TOKEN_BINDING_HOSTNAME: u32 = 168u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_REJECT_USERPWD_IN_URL: u32 = 100u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_REQUEST_PRIORITY: u32 = 58u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_REQUEST_STATS: u32 = 146u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_REQUEST_TIMES: u32 = 142u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_REQUIRE_STREAM_END: u32 = 160u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_RESOLUTION_HOSTNAME: u32 = 165u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_RESOLVER_CACHE_CONFIG: u32 = 170u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_RESOLVE_TIMEOUT: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_SECURE_PROTOCOLS: u32 = 84u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_SECURITY_CERTIFICATE_STRUCT: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_SECURITY_FLAGS: u32 = 31u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_SECURITY_INFO: u32 = 151u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_SECURITY_KEY_BITNESS: u32 = 36u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_SELECTED_PROXY_CONFIG_INFO: u32 = 182u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_SEND_TIMEOUT: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_SERVER_CBT: u32 = 108u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_SERVER_CERT_CHAIN_CONTEXT: u32 = 147u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_SERVER_CERT_CONTEXT: u32 = 78u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_SERVER_SPN_USED: u32 = 106u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_SET_GLOBAL_CALLBACK: u32 = 163u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_SET_TOKEN_BINDING: u32 = 166u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_SOURCE_ADDRESS: u32 = 156u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_SPN: u32 = 96u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_SPN_MASK: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_STREAM_ERROR_CODE: u32 = 159u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_TCP_FAST_OPEN: u32 = 153u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_TCP_KEEPALIVE: u32 = 152u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_TCP_PRIORITY_HINT: u32 = 128u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_TCP_PRIORITY_STATUS: u32 = 177u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_TLS_FALSE_START: u32 = 154u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_TLS_PROTOCOL_INSECURE_FALLBACK: u32 = 158u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_TOKEN_BINDING_PUBLIC_KEY: u32 = 167u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_UNLOAD_NOTIFY_EVENT: u32 = 99u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_UNSAFE_HEADER_PARSING: u32 = 110u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_UPGRADE_TO_WEB_SOCKET: u32 = 114u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_URL: u32 = 34u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_USERNAME: u32 = 4096u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_USER_AGENT: u32 = 41u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_USE_GLOBAL_SERVER_CREDENTIALS: u32 = 101u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_WEB_SOCKET_CLOSE_TIMEOUT: u32 = 115u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_WEB_SOCKET_KEEPALIVE_INTERVAL: u32 = 116u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_WEB_SOCKET_RECEIVE_BUFFER_SIZE: u32 = 122u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_WEB_SOCKET_SEND_BUFFER_SIZE: u32 = 123u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_WORKER_THREAD_COUNT: u32 = 80u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_OPTION_WRITE_BUFFER_SIZE: u32 = 13u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_PROTOCOL_FLAG_HTTP2: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_PROTOCOL_FLAG_HTTP3: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_PROXY_TYPE_AUTO_DETECT: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_PROXY_TYPE_AUTO_PROXY_URL: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_PROXY_TYPE_DIRECT: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_PROXY_TYPE_PROXY: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_ACCEPT: u32 = 24u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_ACCEPT_CHARSET: u32 = 25u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_ACCEPT_ENCODING: u32 = 26u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_ACCEPT_LANGUAGE: u32 = 27u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_ACCEPT_RANGES: u32 = 42u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_AGE: u32 = 48u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_ALLOW: u32 = 7u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_AUTHENTICATION_INFO: u32 = 76u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_AUTHORIZATION: u32 = 28u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_CACHE_CONTROL: u32 = 49u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_CONNECTION: u32 = 23u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_CONTENT_BASE: u32 = 50u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_CONTENT_DESCRIPTION: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_CONTENT_DISPOSITION: u32 = 47u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_CONTENT_ENCODING: u32 = 29u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_CONTENT_ID: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_CONTENT_LANGUAGE: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_CONTENT_LENGTH: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_CONTENT_LOCATION: u32 = 51u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_CONTENT_MD5: u32 = 52u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_CONTENT_RANGE: u32 = 53u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_CONTENT_TRANSFER_ENCODING: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_CONTENT_TYPE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_COOKIE: u32 = 44u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_COST: u32 = 15u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_CUSTOM: u32 = 65535u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_DATE: u32 = 9u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_DERIVED_FROM: u32 = 14u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_ETAG: u32 = 54u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_EXPECT: u32 = 68u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_EXPIRES: u32 = 10u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_EX_ALL_HEADERS: u32 = 21u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_FLAG_NUMBER: u32 = 536870912u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_FLAG_NUMBER64: u32 = 134217728u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_FLAG_REQUEST_HEADERS: u32 = 2147483648u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_FLAG_SYSTEMTIME: u32 = 1073741824u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_FLAG_TRAILERS: u32 = 33554432u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_FLAG_WIRE_ENCODING: u32 = 16777216u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_FORWARDED: u32 = 30u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_FROM: u32 = 31u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_HOST: u32 = 55u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_IF_MATCH: u32 = 56u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_IF_MODIFIED_SINCE: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_IF_NONE_MATCH: u32 = 57u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_IF_RANGE: u32 = 58u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_IF_UNMODIFIED_SINCE: u32 = 59u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_LAST_MODIFIED: u32 = 11u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_LINK: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_LOCATION: u32 = 33u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_MAX: u32 = 78u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_MAX_FORWARDS: u32 = 60u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_MESSAGE_ID: u32 = 12u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_MIME_VERSION: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_ORIG_URI: u32 = 34u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_PASSPORT_CONFIG: u32 = 78u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_PASSPORT_URLS: u32 = 77u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_PRAGMA: u32 = 17u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_PROXY_AUTHENTICATE: u32 = 41u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_PROXY_AUTHORIZATION: u32 = 61u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_PROXY_CONNECTION: u32 = 69u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_PROXY_SUPPORT: u32 = 75u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_PUBLIC: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_RANGE: u32 = 62u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_RAW_HEADERS: u32 = 21u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_RAW_HEADERS_CRLF: u32 = 22u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_REFERER: u32 = 35u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_REFRESH: u32 = 46u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_REQUEST_METHOD: u32 = 45u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_RETRY_AFTER: u32 = 36u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_SERVER: u32 = 37u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_SET_COOKIE: u32 = 43u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_STATUS_CODE: u32 = 19u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_STATUS_TEXT: u32 = 20u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_TITLE: u32 = 38u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_TRANSFER_ENCODING: u32 = 63u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_UNLESS_MODIFIED_SINCE: u32 = 70u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_UPGRADE: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_URI: u32 = 13u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_USER_AGENT: u32 = 39u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_VARY: u32 = 65u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_VERSION: u32 = 18u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_VIA: u32 = 66u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_WARNING: u32 = 67u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_QUERY_WWW_AUTHENTICATE: u32 = 40u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_REQUEST_STAT_FLAG_FIRST_REQUEST: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_REQUEST_STAT_FLAG_PROXY_TLS_FALSE_START: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_REQUEST_STAT_FLAG_PROXY_TLS_SESSION_RESUMPTION: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_REQUEST_STAT_FLAG_TCP_FAST_OPEN: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_REQUEST_STAT_FLAG_TLS_FALSE_START: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_REQUEST_STAT_FLAG_TLS_SESSION_RESUMPTION: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_RESET_ALL: u32 = 65535u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_RESET_DISCARD_RESOLVERS: u32 = 262144u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_RESET_NOTIFY_NETWORK_CHANGED: u32 = 65536u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_RESET_OUT_OF_PROC: u32 = 131072u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_RESET_SCRIPT_CACHE: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_RESET_STATE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_RESET_SWPAD_ALL: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_RESET_SWPAD_CURRENT_NETWORK: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_RESOLVER_CACHE_CONFIG_FLAG_BYPASS_CACHE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_RESOLVER_CACHE_CONFIG_FLAG_CONN_USE_TTL: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_RESOLVER_CACHE_CONFIG_FLAG_SOFT_LIMIT: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_RESOLVER_CACHE_CONFIG_FLAG_USE_DNS_TTL: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_TIME_FORMAT_BUFSIZE: u32 = 62u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_WEB_SOCKET_MAX_CLOSE_REASON_LENGTH: u32 = 123u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_WEB_SOCKET_MIN_KEEPALIVE_VALUE: u32 = 15000u32;
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct INTERNET_PORT(pub u32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const INTERNET_DEFAULT_HTTP_PORT: INTERNET_PORT = INTERNET_PORT(80u32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const INTERNET_DEFAULT_HTTPS_PORT: INTERNET_PORT = INTERNET_PORT(443u32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const INTERNET_DEFAULT_PORT: INTERNET_PORT = INTERNET_PORT(0u32);
impl ::core::marker::Copy for INTERNET_PORT {}
impl ::core::clone::Clone for INTERNET_PORT {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for INTERNET_PORT {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for INTERNET_PORT {
    type Abi = Self;
}
impl ::core::fmt::Debug for INTERNET_PORT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("INTERNET_PORT").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct WINHTTP_ACCESS_TYPE(pub u32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_ACCESS_TYPE_NO_PROXY: WINHTTP_ACCESS_TYPE = WINHTTP_ACCESS_TYPE(1u32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_ACCESS_TYPE_DEFAULT_PROXY: WINHTTP_ACCESS_TYPE = WINHTTP_ACCESS_TYPE(0u32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_ACCESS_TYPE_NAMED_PROXY: WINHTTP_ACCESS_TYPE = WINHTTP_ACCESS_TYPE(3u32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_ACCESS_TYPE_AUTOMATIC_PROXY: WINHTTP_ACCESS_TYPE = WINHTTP_ACCESS_TYPE(4u32);
impl ::core::marker::Copy for WINHTTP_ACCESS_TYPE {}
impl ::core::clone::Clone for WINHTTP_ACCESS_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for WINHTTP_ACCESS_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for WINHTTP_ACCESS_TYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for WINHTTP_ACCESS_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("WINHTTP_ACCESS_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct WINHTTP_CREDS_AUTHSCHEME(pub u32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_AUTH_SCHEME_BASIC: WINHTTP_CREDS_AUTHSCHEME = WINHTTP_CREDS_AUTHSCHEME(1u32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_AUTH_SCHEME_NTLM: WINHTTP_CREDS_AUTHSCHEME = WINHTTP_CREDS_AUTHSCHEME(2u32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_AUTH_SCHEME_NEGOTIATE: WINHTTP_CREDS_AUTHSCHEME = WINHTTP_CREDS_AUTHSCHEME(16u32);
impl ::core::marker::Copy for WINHTTP_CREDS_AUTHSCHEME {}
impl ::core::clone::Clone for WINHTTP_CREDS_AUTHSCHEME {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for WINHTTP_CREDS_AUTHSCHEME {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for WINHTTP_CREDS_AUTHSCHEME {
    type Abi = Self;
}
impl ::core::fmt::Debug for WINHTTP_CREDS_AUTHSCHEME {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("WINHTTP_CREDS_AUTHSCHEME").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct WINHTTP_INTERNET_SCHEME(pub u32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_INTERNET_SCHEME_HTTP: WINHTTP_INTERNET_SCHEME = WINHTTP_INTERNET_SCHEME(1u32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_INTERNET_SCHEME_HTTPS: WINHTTP_INTERNET_SCHEME = WINHTTP_INTERNET_SCHEME(2u32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_INTERNET_SCHEME_FTP: WINHTTP_INTERNET_SCHEME = WINHTTP_INTERNET_SCHEME(3u32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_INTERNET_SCHEME_SOCKS: WINHTTP_INTERNET_SCHEME = WINHTTP_INTERNET_SCHEME(4u32);
impl ::core::marker::Copy for WINHTTP_INTERNET_SCHEME {}
impl ::core::clone::Clone for WINHTTP_INTERNET_SCHEME {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for WINHTTP_INTERNET_SCHEME {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for WINHTTP_INTERNET_SCHEME {
    type Abi = Self;
}
impl ::core::fmt::Debug for WINHTTP_INTERNET_SCHEME {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("WINHTTP_INTERNET_SCHEME").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct WINHTTP_OPEN_REQUEST_FLAGS(pub u32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_FLAG_BYPASS_PROXY_CACHE: WINHTTP_OPEN_REQUEST_FLAGS = WINHTTP_OPEN_REQUEST_FLAGS(256u32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_FLAG_ESCAPE_DISABLE: WINHTTP_OPEN_REQUEST_FLAGS = WINHTTP_OPEN_REQUEST_FLAGS(64u32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_FLAG_ESCAPE_DISABLE_QUERY: WINHTTP_OPEN_REQUEST_FLAGS = WINHTTP_OPEN_REQUEST_FLAGS(128u32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_FLAG_ESCAPE_PERCENT: WINHTTP_OPEN_REQUEST_FLAGS = WINHTTP_OPEN_REQUEST_FLAGS(4u32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_FLAG_NULL_CODEPAGE: WINHTTP_OPEN_REQUEST_FLAGS = WINHTTP_OPEN_REQUEST_FLAGS(8u32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_FLAG_REFRESH: WINHTTP_OPEN_REQUEST_FLAGS = WINHTTP_OPEN_REQUEST_FLAGS(256u32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_FLAG_SECURE: WINHTTP_OPEN_REQUEST_FLAGS = WINHTTP_OPEN_REQUEST_FLAGS(8388608u32);
impl ::core::marker::Copy for WINHTTP_OPEN_REQUEST_FLAGS {}
impl ::core::clone::Clone for WINHTTP_OPEN_REQUEST_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for WINHTTP_OPEN_REQUEST_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for WINHTTP_OPEN_REQUEST_FLAGS {
    type Abi = Self;
}
impl ::core::fmt::Debug for WINHTTP_OPEN_REQUEST_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("WINHTTP_OPEN_REQUEST_FLAGS").field(&self.0).finish()
    }
}
impl ::core::ops::BitOr for WINHTTP_OPEN_REQUEST_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for WINHTTP_OPEN_REQUEST_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for WINHTTP_OPEN_REQUEST_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for WINHTTP_OPEN_REQUEST_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for WINHTTP_OPEN_REQUEST_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct WINHTTP_REQUEST_STAT_ENTRY(pub i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpConnectFailureCount: WINHTTP_REQUEST_STAT_ENTRY = WINHTTP_REQUEST_STAT_ENTRY(0i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpProxyFailureCount: WINHTTP_REQUEST_STAT_ENTRY = WINHTTP_REQUEST_STAT_ENTRY(1i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpTlsHandshakeClientLeg1Size: WINHTTP_REQUEST_STAT_ENTRY = WINHTTP_REQUEST_STAT_ENTRY(2i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpTlsHandshakeServerLeg1Size: WINHTTP_REQUEST_STAT_ENTRY = WINHTTP_REQUEST_STAT_ENTRY(3i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpTlsHandshakeClientLeg2Size: WINHTTP_REQUEST_STAT_ENTRY = WINHTTP_REQUEST_STAT_ENTRY(4i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpTlsHandshakeServerLeg2Size: WINHTTP_REQUEST_STAT_ENTRY = WINHTTP_REQUEST_STAT_ENTRY(5i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpRequestHeadersSize: WINHTTP_REQUEST_STAT_ENTRY = WINHTTP_REQUEST_STAT_ENTRY(6i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpRequestHeadersCompressedSize: WINHTTP_REQUEST_STAT_ENTRY = WINHTTP_REQUEST_STAT_ENTRY(7i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpResponseHeadersSize: WINHTTP_REQUEST_STAT_ENTRY = WINHTTP_REQUEST_STAT_ENTRY(8i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpResponseHeadersCompressedSize: WINHTTP_REQUEST_STAT_ENTRY = WINHTTP_REQUEST_STAT_ENTRY(9i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpResponseBodySize: WINHTTP_REQUEST_STAT_ENTRY = WINHTTP_REQUEST_STAT_ENTRY(10i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpResponseBodyCompressedSize: WINHTTP_REQUEST_STAT_ENTRY = WINHTTP_REQUEST_STAT_ENTRY(11i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpProxyTlsHandshakeClientLeg1Size: WINHTTP_REQUEST_STAT_ENTRY = WINHTTP_REQUEST_STAT_ENTRY(12i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpProxyTlsHandshakeServerLeg1Size: WINHTTP_REQUEST_STAT_ENTRY = WINHTTP_REQUEST_STAT_ENTRY(13i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpProxyTlsHandshakeClientLeg2Size: WINHTTP_REQUEST_STAT_ENTRY = WINHTTP_REQUEST_STAT_ENTRY(14i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpProxyTlsHandshakeServerLeg2Size: WINHTTP_REQUEST_STAT_ENTRY = WINHTTP_REQUEST_STAT_ENTRY(15i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpRequestStatLast: WINHTTP_REQUEST_STAT_ENTRY = WINHTTP_REQUEST_STAT_ENTRY(16i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpRequestStatMax: WINHTTP_REQUEST_STAT_ENTRY = WINHTTP_REQUEST_STAT_ENTRY(32i32);
impl ::core::marker::Copy for WINHTTP_REQUEST_STAT_ENTRY {}
impl ::core::clone::Clone for WINHTTP_REQUEST_STAT_ENTRY {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for WINHTTP_REQUEST_STAT_ENTRY {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for WINHTTP_REQUEST_STAT_ENTRY {
    type Abi = Self;
}
impl ::core::fmt::Debug for WINHTTP_REQUEST_STAT_ENTRY {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("WINHTTP_REQUEST_STAT_ENTRY").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct WINHTTP_REQUEST_TIME_ENTRY(pub i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpProxyDetectionStart: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(0i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpProxyDetectionEnd: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(1i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpConnectionAcquireStart: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(2i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpConnectionAcquireWaitEnd: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(3i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpConnectionAcquireEnd: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(4i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpNameResolutionStart: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(5i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpNameResolutionEnd: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(6i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpConnectionEstablishmentStart: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(7i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpConnectionEstablishmentEnd: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(8i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpTlsHandshakeClientLeg1Start: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(9i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpTlsHandshakeClientLeg1End: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(10i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpTlsHandshakeClientLeg2Start: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(11i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpTlsHandshakeClientLeg2End: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(12i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpTlsHandshakeClientLeg3Start: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(13i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpTlsHandshakeClientLeg3End: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(14i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpStreamWaitStart: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(15i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpStreamWaitEnd: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(16i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpSendRequestStart: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(17i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpSendRequestHeadersCompressionStart: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(18i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpSendRequestHeadersCompressionEnd: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(19i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpSendRequestHeadersEnd: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(20i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpSendRequestEnd: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(21i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpReceiveResponseStart: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(22i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpReceiveResponseHeadersDecompressionStart: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(23i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpReceiveResponseHeadersDecompressionEnd: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(24i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpReceiveResponseHeadersEnd: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(25i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpReceiveResponseBodyDecompressionDelta: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(26i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpReceiveResponseEnd: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(27i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpProxyTunnelStart: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(28i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpProxyTunnelEnd: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(29i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpProxyTlsHandshakeClientLeg1Start: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(30i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpProxyTlsHandshakeClientLeg1End: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(31i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpProxyTlsHandshakeClientLeg2Start: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(32i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpProxyTlsHandshakeClientLeg2End: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(33i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpProxyTlsHandshakeClientLeg3Start: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(34i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpProxyTlsHandshakeClientLeg3End: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(35i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpRequestTimeLast: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(36i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpRequestTimeMax: WINHTTP_REQUEST_TIME_ENTRY = WINHTTP_REQUEST_TIME_ENTRY(64i32);
impl ::core::marker::Copy for WINHTTP_REQUEST_TIME_ENTRY {}
impl ::core::clone::Clone for WINHTTP_REQUEST_TIME_ENTRY {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for WINHTTP_REQUEST_TIME_ENTRY {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for WINHTTP_REQUEST_TIME_ENTRY {
    type Abi = Self;
}
impl ::core::fmt::Debug for WINHTTP_REQUEST_TIME_ENTRY {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("WINHTTP_REQUEST_TIME_ENTRY").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct WINHTTP_SECURE_DNS_SETTING(pub i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpSecureDnsSettingDefault: WINHTTP_SECURE_DNS_SETTING = WINHTTP_SECURE_DNS_SETTING(0i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpSecureDnsSettingForcePlaintext: WINHTTP_SECURE_DNS_SETTING = WINHTTP_SECURE_DNS_SETTING(1i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpSecureDnsSettingRequireEncryption: WINHTTP_SECURE_DNS_SETTING = WINHTTP_SECURE_DNS_SETTING(2i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpSecureDnsSettingTryEncryptionWithFallback: WINHTTP_SECURE_DNS_SETTING = WINHTTP_SECURE_DNS_SETTING(3i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WinHttpSecureDnsSettingMax: WINHTTP_SECURE_DNS_SETTING = WINHTTP_SECURE_DNS_SETTING(4i32);
impl ::core::marker::Copy for WINHTTP_SECURE_DNS_SETTING {}
impl ::core::clone::Clone for WINHTTP_SECURE_DNS_SETTING {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for WINHTTP_SECURE_DNS_SETTING {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for WINHTTP_SECURE_DNS_SETTING {
    type Abi = Self;
}
impl ::core::fmt::Debug for WINHTTP_SECURE_DNS_SETTING {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("WINHTTP_SECURE_DNS_SETTING").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct WINHTTP_WEB_SOCKET_BUFFER_TYPE(pub i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_WEB_SOCKET_BINARY_MESSAGE_BUFFER_TYPE: WINHTTP_WEB_SOCKET_BUFFER_TYPE = WINHTTP_WEB_SOCKET_BUFFER_TYPE(0i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_WEB_SOCKET_BINARY_FRAGMENT_BUFFER_TYPE: WINHTTP_WEB_SOCKET_BUFFER_TYPE = WINHTTP_WEB_SOCKET_BUFFER_TYPE(1i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_WEB_SOCKET_UTF8_MESSAGE_BUFFER_TYPE: WINHTTP_WEB_SOCKET_BUFFER_TYPE = WINHTTP_WEB_SOCKET_BUFFER_TYPE(2i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_WEB_SOCKET_UTF8_FRAGMENT_BUFFER_TYPE: WINHTTP_WEB_SOCKET_BUFFER_TYPE = WINHTTP_WEB_SOCKET_BUFFER_TYPE(3i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_WEB_SOCKET_CLOSE_BUFFER_TYPE: WINHTTP_WEB_SOCKET_BUFFER_TYPE = WINHTTP_WEB_SOCKET_BUFFER_TYPE(4i32);
impl ::core::marker::Copy for WINHTTP_WEB_SOCKET_BUFFER_TYPE {}
impl ::core::clone::Clone for WINHTTP_WEB_SOCKET_BUFFER_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for WINHTTP_WEB_SOCKET_BUFFER_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for WINHTTP_WEB_SOCKET_BUFFER_TYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for WINHTTP_WEB_SOCKET_BUFFER_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("WINHTTP_WEB_SOCKET_BUFFER_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct WINHTTP_WEB_SOCKET_CLOSE_STATUS(pub i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_WEB_SOCKET_SUCCESS_CLOSE_STATUS: WINHTTP_WEB_SOCKET_CLOSE_STATUS = WINHTTP_WEB_SOCKET_CLOSE_STATUS(1000i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_WEB_SOCKET_ENDPOINT_TERMINATED_CLOSE_STATUS: WINHTTP_WEB_SOCKET_CLOSE_STATUS = WINHTTP_WEB_SOCKET_CLOSE_STATUS(1001i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_WEB_SOCKET_PROTOCOL_ERROR_CLOSE_STATUS: WINHTTP_WEB_SOCKET_CLOSE_STATUS = WINHTTP_WEB_SOCKET_CLOSE_STATUS(1002i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_WEB_SOCKET_INVALID_DATA_TYPE_CLOSE_STATUS: WINHTTP_WEB_SOCKET_CLOSE_STATUS = WINHTTP_WEB_SOCKET_CLOSE_STATUS(1003i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_WEB_SOCKET_EMPTY_CLOSE_STATUS: WINHTTP_WEB_SOCKET_CLOSE_STATUS = WINHTTP_WEB_SOCKET_CLOSE_STATUS(1005i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_WEB_SOCKET_ABORTED_CLOSE_STATUS: WINHTTP_WEB_SOCKET_CLOSE_STATUS = WINHTTP_WEB_SOCKET_CLOSE_STATUS(1006i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_WEB_SOCKET_INVALID_PAYLOAD_CLOSE_STATUS: WINHTTP_WEB_SOCKET_CLOSE_STATUS = WINHTTP_WEB_SOCKET_CLOSE_STATUS(1007i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_WEB_SOCKET_POLICY_VIOLATION_CLOSE_STATUS: WINHTTP_WEB_SOCKET_CLOSE_STATUS = WINHTTP_WEB_SOCKET_CLOSE_STATUS(1008i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_WEB_SOCKET_MESSAGE_TOO_BIG_CLOSE_STATUS: WINHTTP_WEB_SOCKET_CLOSE_STATUS = WINHTTP_WEB_SOCKET_CLOSE_STATUS(1009i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_WEB_SOCKET_UNSUPPORTED_EXTENSIONS_CLOSE_STATUS: WINHTTP_WEB_SOCKET_CLOSE_STATUS = WINHTTP_WEB_SOCKET_CLOSE_STATUS(1010i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_WEB_SOCKET_SERVER_ERROR_CLOSE_STATUS: WINHTTP_WEB_SOCKET_CLOSE_STATUS = WINHTTP_WEB_SOCKET_CLOSE_STATUS(1011i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_WEB_SOCKET_SECURE_HANDSHAKE_ERROR_CLOSE_STATUS: WINHTTP_WEB_SOCKET_CLOSE_STATUS = WINHTTP_WEB_SOCKET_CLOSE_STATUS(1015i32);
impl ::core::marker::Copy for WINHTTP_WEB_SOCKET_CLOSE_STATUS {}
impl ::core::clone::Clone for WINHTTP_WEB_SOCKET_CLOSE_STATUS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for WINHTTP_WEB_SOCKET_CLOSE_STATUS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for WINHTTP_WEB_SOCKET_CLOSE_STATUS {
    type Abi = Self;
}
impl ::core::fmt::Debug for WINHTTP_WEB_SOCKET_CLOSE_STATUS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("WINHTTP_WEB_SOCKET_CLOSE_STATUS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct WINHTTP_WEB_SOCKET_OPERATION(pub i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_WEB_SOCKET_SEND_OPERATION: WINHTTP_WEB_SOCKET_OPERATION = WINHTTP_WEB_SOCKET_OPERATION(0i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_WEB_SOCKET_RECEIVE_OPERATION: WINHTTP_WEB_SOCKET_OPERATION = WINHTTP_WEB_SOCKET_OPERATION(1i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_WEB_SOCKET_CLOSE_OPERATION: WINHTTP_WEB_SOCKET_OPERATION = WINHTTP_WEB_SOCKET_OPERATION(2i32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const WINHTTP_WEB_SOCKET_SHUTDOWN_OPERATION: WINHTTP_WEB_SOCKET_OPERATION = WINHTTP_WEB_SOCKET_OPERATION(3i32);
impl ::core::marker::Copy for WINHTTP_WEB_SOCKET_OPERATION {}
impl ::core::clone::Clone for WINHTTP_WEB_SOCKET_OPERATION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for WINHTTP_WEB_SOCKET_OPERATION {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for WINHTTP_WEB_SOCKET_OPERATION {
    type Abi = Self;
}
impl ::core::fmt::Debug for WINHTTP_WEB_SOCKET_OPERATION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("WINHTTP_WEB_SOCKET_OPERATION").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct WIN_HTTP_CREATE_URL_FLAGS(pub u32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ICU_ESCAPE: WIN_HTTP_CREATE_URL_FLAGS = WIN_HTTP_CREATE_URL_FLAGS(2147483648u32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ICU_REJECT_USERPWD: WIN_HTTP_CREATE_URL_FLAGS = WIN_HTTP_CREATE_URL_FLAGS(16384u32);
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub const ICU_DECODE: WIN_HTTP_CREATE_URL_FLAGS = WIN_HTTP_CREATE_URL_FLAGS(268435456u32);
impl ::core::marker::Copy for WIN_HTTP_CREATE_URL_FLAGS {}
impl ::core::clone::Clone for WIN_HTTP_CREATE_URL_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for WIN_HTTP_CREATE_URL_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for WIN_HTTP_CREATE_URL_FLAGS {
    type Abi = Self;
}
impl ::core::fmt::Debug for WIN_HTTP_CREATE_URL_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("WIN_HTTP_CREATE_URL_FLAGS").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub struct HTTP_VERSION_INFO {
    pub dwMajorVersion: u32,
    pub dwMinorVersion: u32,
}
impl ::core::marker::Copy for HTTP_VERSION_INFO {}
impl ::core::clone::Clone for HTTP_VERSION_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for HTTP_VERSION_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("HTTP_VERSION_INFO").field("dwMajorVersion", &self.dwMajorVersion).field("dwMinorVersion", &self.dwMinorVersion).finish()
    }
}
unsafe impl ::windows::core::Abi for HTTP_VERSION_INFO {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for HTTP_VERSION_INFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<HTTP_VERSION_INFO>()) == 0 }
    }
}
impl ::core::cmp::Eq for HTTP_VERSION_INFO {}
impl ::core::default::Default for HTTP_VERSION_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub struct URL_COMPONENTS {
    pub dwStructSize: u32,
    pub lpszScheme: ::windows::core::PWSTR,
    pub dwSchemeLength: u32,
    pub nScheme: WINHTTP_INTERNET_SCHEME,
    pub lpszHostName: ::windows::core::PWSTR,
    pub dwHostNameLength: u32,
    pub nPort: u16,
    pub lpszUserName: ::windows::core::PWSTR,
    pub dwUserNameLength: u32,
    pub lpszPassword: ::windows::core::PWSTR,
    pub dwPasswordLength: u32,
    pub lpszUrlPath: ::windows::core::PWSTR,
    pub dwUrlPathLength: u32,
    pub lpszExtraInfo: ::windows::core::PWSTR,
    pub dwExtraInfoLength: u32,
}
impl ::core::marker::Copy for URL_COMPONENTS {}
impl ::core::clone::Clone for URL_COMPONENTS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for URL_COMPONENTS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("URL_COMPONENTS")
            .field("dwStructSize", &self.dwStructSize)
            .field("lpszScheme", &self.lpszScheme)
            .field("dwSchemeLength", &self.dwSchemeLength)
            .field("nScheme", &self.nScheme)
            .field("lpszHostName", &self.lpszHostName)
            .field("dwHostNameLength", &self.dwHostNameLength)
            .field("nPort", &self.nPort)
            .field("lpszUserName", &self.lpszUserName)
            .field("dwUserNameLength", &self.dwUserNameLength)
            .field("lpszPassword", &self.lpszPassword)
            .field("dwPasswordLength", &self.dwPasswordLength)
            .field("lpszUrlPath", &self.lpszUrlPath)
            .field("dwUrlPathLength", &self.dwUrlPathLength)
            .field("lpszExtraInfo", &self.lpszExtraInfo)
            .field("dwExtraInfoLength", &self.dwExtraInfoLength)
            .finish()
    }
}
unsafe impl ::windows::core::Abi for URL_COMPONENTS {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for URL_COMPONENTS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<URL_COMPONENTS>()) == 0 }
    }
}
impl ::core::cmp::Eq for URL_COMPONENTS {}
impl ::core::default::Default for URL_COMPONENTS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub struct WINHTTP_ASYNC_RESULT {
    pub dwResult: usize,
    pub dwError: u32,
}
impl ::core::marker::Copy for WINHTTP_ASYNC_RESULT {}
impl ::core::clone::Clone for WINHTTP_ASYNC_RESULT {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for WINHTTP_ASYNC_RESULT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("WINHTTP_ASYNC_RESULT").field("dwResult", &self.dwResult).field("dwError", &self.dwError).finish()
    }
}
unsafe impl ::windows::core::Abi for WINHTTP_ASYNC_RESULT {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for WINHTTP_ASYNC_RESULT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<WINHTTP_ASYNC_RESULT>()) == 0 }
    }
}
impl ::core::cmp::Eq for WINHTTP_ASYNC_RESULT {}
impl ::core::default::Default for WINHTTP_ASYNC_RESULT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct WINHTTP_AUTOPROXY_OPTIONS {
    pub dwFlags: u32,
    pub dwAutoDetectFlags: u32,
    pub lpszAutoConfigUrl: ::windows::core::PCWSTR,
    pub lpvReserved: *mut ::core::ffi::c_void,
    pub dwReserved: u32,
    pub fAutoLogonIfChallenged: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for WINHTTP_AUTOPROXY_OPTIONS {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for WINHTTP_AUTOPROXY_OPTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for WINHTTP_AUTOPROXY_OPTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("WINHTTP_AUTOPROXY_OPTIONS").field("dwFlags", &self.dwFlags).field("dwAutoDetectFlags", &self.dwAutoDetectFlags).field("lpszAutoConfigUrl", &self.lpszAutoConfigUrl).field("lpvReserved", &self.lpvReserved).field("dwReserved", &self.dwReserved).field("fAutoLogonIfChallenged", &self.fAutoLogonIfChallenged).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for WINHTTP_AUTOPROXY_OPTIONS {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for WINHTTP_AUTOPROXY_OPTIONS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<WINHTTP_AUTOPROXY_OPTIONS>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for WINHTTP_AUTOPROXY_OPTIONS {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for WINHTTP_AUTOPROXY_OPTIONS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct WINHTTP_CERTIFICATE_INFO {
    pub ftExpiry: super::super::Foundation::FILETIME,
    pub ftStart: super::super::Foundation::FILETIME,
    pub lpszSubjectInfo: ::windows::core::PWSTR,
    pub lpszIssuerInfo: ::windows::core::PWSTR,
    pub lpszProtocolName: ::windows::core::PWSTR,
    pub lpszSignatureAlgName: ::windows::core::PWSTR,
    pub lpszEncryptionAlgName: ::windows::core::PWSTR,
    pub dwKeySize: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for WINHTTP_CERTIFICATE_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for WINHTTP_CERTIFICATE_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for WINHTTP_CERTIFICATE_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("WINHTTP_CERTIFICATE_INFO").field("ftExpiry", &self.ftExpiry).field("ftStart", &self.ftStart).field("lpszSubjectInfo", &self.lpszSubjectInfo).field("lpszIssuerInfo", &self.lpszIssuerInfo).field("lpszProtocolName", &self.lpszProtocolName).field("lpszSignatureAlgName", &self.lpszSignatureAlgName).field("lpszEncryptionAlgName", &self.lpszEncryptionAlgName).field("dwKeySize", &self.dwKeySize).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for WINHTTP_CERTIFICATE_INFO {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for WINHTTP_CERTIFICATE_INFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<WINHTTP_CERTIFICATE_INFO>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for WINHTTP_CERTIFICATE_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for WINHTTP_CERTIFICATE_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub struct WINHTTP_CONNECTION_GROUP {
    pub cConnections: u32,
    pub guidGroup: ::windows::core::GUID,
}
impl ::core::marker::Copy for WINHTTP_CONNECTION_GROUP {}
impl ::core::clone::Clone for WINHTTP_CONNECTION_GROUP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for WINHTTP_CONNECTION_GROUP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("WINHTTP_CONNECTION_GROUP").field("cConnections", &self.cConnections).field("guidGroup", &self.guidGroup).finish()
    }
}
unsafe impl ::windows::core::Abi for WINHTTP_CONNECTION_GROUP {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for WINHTTP_CONNECTION_GROUP {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<WINHTTP_CONNECTION_GROUP>()) == 0 }
    }
}
impl ::core::cmp::Eq for WINHTTP_CONNECTION_GROUP {}
impl ::core::default::Default for WINHTTP_CONNECTION_GROUP {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`, `\"Win32_Networking_WinSock\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Networking_WinSock"))]
pub struct WINHTTP_CONNECTION_INFO {
    pub cbSize: u32,
    pub LocalAddress: super::WinSock::SOCKADDR_STORAGE,
    pub RemoteAddress: super::WinSock::SOCKADDR_STORAGE,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Networking_WinSock"))]
impl ::core::marker::Copy for WINHTTP_CONNECTION_INFO {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Networking_WinSock"))]
impl ::core::clone::Clone for WINHTTP_CONNECTION_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Networking_WinSock"))]
unsafe impl ::windows::core::Abi for WINHTTP_CONNECTION_INFO {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Networking_WinSock"))]
impl ::core::cmp::PartialEq for WINHTTP_CONNECTION_INFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<WINHTTP_CONNECTION_INFO>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Networking_WinSock"))]
impl ::core::cmp::Eq for WINHTTP_CONNECTION_INFO {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Networking_WinSock"))]
impl ::core::default::Default for WINHTTP_CONNECTION_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(4))]
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`, `\"Win32_Networking_WinSock\"`*"]
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Networking_WinSock"))]
pub struct WINHTTP_CONNECTION_INFO {
    pub cbSize: u32,
    pub LocalAddress: super::WinSock::SOCKADDR_STORAGE,
    pub RemoteAddress: super::WinSock::SOCKADDR_STORAGE,
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Networking_WinSock"))]
impl ::core::marker::Copy for WINHTTP_CONNECTION_INFO {}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Networking_WinSock"))]
impl ::core::clone::Clone for WINHTTP_CONNECTION_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Networking_WinSock"))]
unsafe impl ::windows::core::Abi for WINHTTP_CONNECTION_INFO {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Networking_WinSock"))]
impl ::core::cmp::PartialEq for WINHTTP_CONNECTION_INFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<WINHTTP_CONNECTION_INFO>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Networking_WinSock"))]
impl ::core::cmp::Eq for WINHTTP_CONNECTION_INFO {}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Networking_WinSock"))]
impl ::core::default::Default for WINHTTP_CONNECTION_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub struct WINHTTP_CREDS {
    pub lpszUserName: ::windows::core::PSTR,
    pub lpszPassword: ::windows::core::PSTR,
    pub lpszRealm: ::windows::core::PSTR,
    pub dwAuthScheme: WINHTTP_CREDS_AUTHSCHEME,
    pub lpszHostName: ::windows::core::PSTR,
    pub dwPort: u32,
}
impl ::core::marker::Copy for WINHTTP_CREDS {}
impl ::core::clone::Clone for WINHTTP_CREDS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for WINHTTP_CREDS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("WINHTTP_CREDS").field("lpszUserName", &self.lpszUserName).field("lpszPassword", &self.lpszPassword).field("lpszRealm", &self.lpszRealm).field("dwAuthScheme", &self.dwAuthScheme).field("lpszHostName", &self.lpszHostName).field("dwPort", &self.dwPort).finish()
    }
}
unsafe impl ::windows::core::Abi for WINHTTP_CREDS {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for WINHTTP_CREDS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<WINHTTP_CREDS>()) == 0 }
    }
}
impl ::core::cmp::Eq for WINHTTP_CREDS {}
impl ::core::default::Default for WINHTTP_CREDS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub struct WINHTTP_CREDS_EX {
    pub lpszUserName: ::windows::core::PSTR,
    pub lpszPassword: ::windows::core::PSTR,
    pub lpszRealm: ::windows::core::PSTR,
    pub dwAuthScheme: WINHTTP_CREDS_AUTHSCHEME,
    pub lpszHostName: ::windows::core::PSTR,
    pub dwPort: u32,
    pub lpszUrl: ::windows::core::PSTR,
}
impl ::core::marker::Copy for WINHTTP_CREDS_EX {}
impl ::core::clone::Clone for WINHTTP_CREDS_EX {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for WINHTTP_CREDS_EX {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("WINHTTP_CREDS_EX").field("lpszUserName", &self.lpszUserName).field("lpszPassword", &self.lpszPassword).field("lpszRealm", &self.lpszRealm).field("dwAuthScheme", &self.dwAuthScheme).field("lpszHostName", &self.lpszHostName).field("dwPort", &self.dwPort).field("lpszUrl", &self.lpszUrl).finish()
    }
}
unsafe impl ::windows::core::Abi for WINHTTP_CREDS_EX {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for WINHTTP_CREDS_EX {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<WINHTTP_CREDS_EX>()) == 0 }
    }
}
impl ::core::cmp::Eq for WINHTTP_CREDS_EX {}
impl ::core::default::Default for WINHTTP_CREDS_EX {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct WINHTTP_CURRENT_USER_IE_PROXY_CONFIG {
    pub fAutoDetect: super::super::Foundation::BOOL,
    pub lpszAutoConfigUrl: ::windows::core::PWSTR,
    pub lpszProxy: ::windows::core::PWSTR,
    pub lpszProxyBypass: ::windows::core::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for WINHTTP_CURRENT_USER_IE_PROXY_CONFIG {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for WINHTTP_CURRENT_USER_IE_PROXY_CONFIG {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for WINHTTP_CURRENT_USER_IE_PROXY_CONFIG {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("WINHTTP_CURRENT_USER_IE_PROXY_CONFIG").field("fAutoDetect", &self.fAutoDetect).field("lpszAutoConfigUrl", &self.lpszAutoConfigUrl).field("lpszProxy", &self.lpszProxy).field("lpszProxyBypass", &self.lpszProxyBypass).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for WINHTTP_CURRENT_USER_IE_PROXY_CONFIG {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for WINHTTP_CURRENT_USER_IE_PROXY_CONFIG {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<WINHTTP_CURRENT_USER_IE_PROXY_CONFIG>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for WINHTTP_CURRENT_USER_IE_PROXY_CONFIG {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for WINHTTP_CURRENT_USER_IE_PROXY_CONFIG {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub struct WINHTTP_EXTENDED_HEADER {
    pub Anonymous1: WINHTTP_EXTENDED_HEADER_0,
    pub Anonymous2: WINHTTP_EXTENDED_HEADER_1,
}
impl ::core::marker::Copy for WINHTTP_EXTENDED_HEADER {}
impl ::core::clone::Clone for WINHTTP_EXTENDED_HEADER {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for WINHTTP_EXTENDED_HEADER {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for WINHTTP_EXTENDED_HEADER {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<WINHTTP_EXTENDED_HEADER>()) == 0 }
    }
}
impl ::core::cmp::Eq for WINHTTP_EXTENDED_HEADER {}
impl ::core::default::Default for WINHTTP_EXTENDED_HEADER {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub union WINHTTP_EXTENDED_HEADER_0 {
    pub pwszName: ::windows::core::PCWSTR,
    pub pszName: ::windows::core::PCSTR,
}
impl ::core::marker::Copy for WINHTTP_EXTENDED_HEADER_0 {}
impl ::core::clone::Clone for WINHTTP_EXTENDED_HEADER_0 {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for WINHTTP_EXTENDED_HEADER_0 {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for WINHTTP_EXTENDED_HEADER_0 {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<WINHTTP_EXTENDED_HEADER_0>()) == 0 }
    }
}
impl ::core::cmp::Eq for WINHTTP_EXTENDED_HEADER_0 {}
impl ::core::default::Default for WINHTTP_EXTENDED_HEADER_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub union WINHTTP_EXTENDED_HEADER_1 {
    pub pwszValue: ::windows::core::PCWSTR,
    pub pszValue: ::windows::core::PCSTR,
}
impl ::core::marker::Copy for WINHTTP_EXTENDED_HEADER_1 {}
impl ::core::clone::Clone for WINHTTP_EXTENDED_HEADER_1 {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for WINHTTP_EXTENDED_HEADER_1 {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for WINHTTP_EXTENDED_HEADER_1 {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<WINHTTP_EXTENDED_HEADER_1>()) == 0 }
    }
}
impl ::core::cmp::Eq for WINHTTP_EXTENDED_HEADER_1 {}
impl ::core::default::Default for WINHTTP_EXTENDED_HEADER_1 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub struct WINHTTP_FAILED_CONNECTION_RETRIES {
    pub dwMaxRetries: u32,
    pub dwAllowedRetryConditions: u32,
}
impl ::core::marker::Copy for WINHTTP_FAILED_CONNECTION_RETRIES {}
impl ::core::clone::Clone for WINHTTP_FAILED_CONNECTION_RETRIES {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for WINHTTP_FAILED_CONNECTION_RETRIES {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("WINHTTP_FAILED_CONNECTION_RETRIES").field("dwMaxRetries", &self.dwMaxRetries).field("dwAllowedRetryConditions", &self.dwAllowedRetryConditions).finish()
    }
}
unsafe impl ::windows::core::Abi for WINHTTP_FAILED_CONNECTION_RETRIES {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for WINHTTP_FAILED_CONNECTION_RETRIES {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<WINHTTP_FAILED_CONNECTION_RETRIES>()) == 0 }
    }
}
impl ::core::cmp::Eq for WINHTTP_FAILED_CONNECTION_RETRIES {}
impl ::core::default::Default for WINHTTP_FAILED_CONNECTION_RETRIES {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub union WINHTTP_HEADER_NAME {
    pub pwszName: ::windows::core::PCWSTR,
    pub pszName: ::windows::core::PCSTR,
}
impl ::core::marker::Copy for WINHTTP_HEADER_NAME {}
impl ::core::clone::Clone for WINHTTP_HEADER_NAME {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for WINHTTP_HEADER_NAME {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for WINHTTP_HEADER_NAME {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<WINHTTP_HEADER_NAME>()) == 0 }
    }
}
impl ::core::cmp::Eq for WINHTTP_HEADER_NAME {}
impl ::core::default::Default for WINHTTP_HEADER_NAME {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub struct WINHTTP_HOST_CONNECTION_GROUP {
    pub pwszHost: ::windows::core::PCWSTR,
    pub cConnectionGroups: u32,
    pub pConnectionGroups: *mut WINHTTP_CONNECTION_GROUP,
}
impl ::core::marker::Copy for WINHTTP_HOST_CONNECTION_GROUP {}
impl ::core::clone::Clone for WINHTTP_HOST_CONNECTION_GROUP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for WINHTTP_HOST_CONNECTION_GROUP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("WINHTTP_HOST_CONNECTION_GROUP").field("pwszHost", &self.pwszHost).field("cConnectionGroups", &self.cConnectionGroups).field("pConnectionGroups", &self.pConnectionGroups).finish()
    }
}
unsafe impl ::windows::core::Abi for WINHTTP_HOST_CONNECTION_GROUP {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for WINHTTP_HOST_CONNECTION_GROUP {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<WINHTTP_HOST_CONNECTION_GROUP>()) == 0 }
    }
}
impl ::core::cmp::Eq for WINHTTP_HOST_CONNECTION_GROUP {}
impl ::core::default::Default for WINHTTP_HOST_CONNECTION_GROUP {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub struct WINHTTP_HTTP2_RECEIVE_WINDOW {
    pub ulStreamWindow: u32,
    pub ulStreamWindowUpdateDelta: u32,
}
impl ::core::marker::Copy for WINHTTP_HTTP2_RECEIVE_WINDOW {}
impl ::core::clone::Clone for WINHTTP_HTTP2_RECEIVE_WINDOW {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for WINHTTP_HTTP2_RECEIVE_WINDOW {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("WINHTTP_HTTP2_RECEIVE_WINDOW").field("ulStreamWindow", &self.ulStreamWindow).field("ulStreamWindowUpdateDelta", &self.ulStreamWindowUpdateDelta).finish()
    }
}
unsafe impl ::windows::core::Abi for WINHTTP_HTTP2_RECEIVE_WINDOW {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for WINHTTP_HTTP2_RECEIVE_WINDOW {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<WINHTTP_HTTP2_RECEIVE_WINDOW>()) == 0 }
    }
}
impl ::core::cmp::Eq for WINHTTP_HTTP2_RECEIVE_WINDOW {}
impl ::core::default::Default for WINHTTP_HTTP2_RECEIVE_WINDOW {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
pub struct WINHTTP_MATCH_CONNECTION_GUID {
    pub ConnectionGuid: ::windows::core::GUID,
    pub ullFlags: u64,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::marker::Copy for WINHTTP_MATCH_CONNECTION_GUID {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::clone::Clone for WINHTTP_MATCH_CONNECTION_GUID {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
unsafe impl ::windows::core::Abi for WINHTTP_MATCH_CONNECTION_GUID {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::PartialEq for WINHTTP_MATCH_CONNECTION_GUID {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<WINHTTP_MATCH_CONNECTION_GUID>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::Eq for WINHTTP_MATCH_CONNECTION_GUID {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::default::Default for WINHTTP_MATCH_CONNECTION_GUID {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(4))]
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
#[cfg(target_arch = "x86")]
pub struct WINHTTP_MATCH_CONNECTION_GUID {
    pub ConnectionGuid: ::windows::core::GUID,
    pub ullFlags: u64,
}
#[cfg(target_arch = "x86")]
impl ::core::marker::Copy for WINHTTP_MATCH_CONNECTION_GUID {}
#[cfg(target_arch = "x86")]
impl ::core::clone::Clone for WINHTTP_MATCH_CONNECTION_GUID {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
unsafe impl ::windows::core::Abi for WINHTTP_MATCH_CONNECTION_GUID {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::PartialEq for WINHTTP_MATCH_CONNECTION_GUID {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<WINHTTP_MATCH_CONNECTION_GUID>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::Eq for WINHTTP_MATCH_CONNECTION_GUID {}
#[cfg(target_arch = "x86")]
impl ::core::default::Default for WINHTTP_MATCH_CONNECTION_GUID {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub struct WINHTTP_PROXY_INFO {
    pub dwAccessType: WINHTTP_ACCESS_TYPE,
    pub lpszProxy: ::windows::core::PWSTR,
    pub lpszProxyBypass: ::windows::core::PWSTR,
}
impl ::core::marker::Copy for WINHTTP_PROXY_INFO {}
impl ::core::clone::Clone for WINHTTP_PROXY_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for WINHTTP_PROXY_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("WINHTTP_PROXY_INFO").field("dwAccessType", &self.dwAccessType).field("lpszProxy", &self.lpszProxy).field("lpszProxyBypass", &self.lpszProxyBypass).finish()
    }
}
unsafe impl ::windows::core::Abi for WINHTTP_PROXY_INFO {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for WINHTTP_PROXY_INFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<WINHTTP_PROXY_INFO>()) == 0 }
    }
}
impl ::core::cmp::Eq for WINHTTP_PROXY_INFO {}
impl ::core::default::Default for WINHTTP_PROXY_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub struct WINHTTP_PROXY_NETWORKING_KEY {
    pub pbBuffer: [u8; 128],
}
impl ::core::marker::Copy for WINHTTP_PROXY_NETWORKING_KEY {}
impl ::core::clone::Clone for WINHTTP_PROXY_NETWORKING_KEY {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for WINHTTP_PROXY_NETWORKING_KEY {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("WINHTTP_PROXY_NETWORKING_KEY").field("pbBuffer", &self.pbBuffer).finish()
    }
}
unsafe impl ::windows::core::Abi for WINHTTP_PROXY_NETWORKING_KEY {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for WINHTTP_PROXY_NETWORKING_KEY {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<WINHTTP_PROXY_NETWORKING_KEY>()) == 0 }
    }
}
impl ::core::cmp::Eq for WINHTTP_PROXY_NETWORKING_KEY {}
impl ::core::default::Default for WINHTTP_PROXY_NETWORKING_KEY {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct WINHTTP_PROXY_RESULT {
    pub cEntries: u32,
    pub pEntries: *mut WINHTTP_PROXY_RESULT_ENTRY,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for WINHTTP_PROXY_RESULT {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for WINHTTP_PROXY_RESULT {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for WINHTTP_PROXY_RESULT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("WINHTTP_PROXY_RESULT").field("cEntries", &self.cEntries).field("pEntries", &self.pEntries).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for WINHTTP_PROXY_RESULT {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for WINHTTP_PROXY_RESULT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<WINHTTP_PROXY_RESULT>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for WINHTTP_PROXY_RESULT {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for WINHTTP_PROXY_RESULT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct WINHTTP_PROXY_RESULT_ENTRY {
    pub fProxy: super::super::Foundation::BOOL,
    pub fBypass: super::super::Foundation::BOOL,
    pub ProxyScheme: WINHTTP_INTERNET_SCHEME,
    pub pwszProxy: ::windows::core::PWSTR,
    pub ProxyPort: u16,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for WINHTTP_PROXY_RESULT_ENTRY {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for WINHTTP_PROXY_RESULT_ENTRY {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for WINHTTP_PROXY_RESULT_ENTRY {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("WINHTTP_PROXY_RESULT_ENTRY").field("fProxy", &self.fProxy).field("fBypass", &self.fBypass).field("ProxyScheme", &self.ProxyScheme).field("pwszProxy", &self.pwszProxy).field("ProxyPort", &self.ProxyPort).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for WINHTTP_PROXY_RESULT_ENTRY {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for WINHTTP_PROXY_RESULT_ENTRY {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<WINHTTP_PROXY_RESULT_ENTRY>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for WINHTTP_PROXY_RESULT_ENTRY {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for WINHTTP_PROXY_RESULT_ENTRY {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct WINHTTP_PROXY_RESULT_EX {
    pub cEntries: u32,
    pub pEntries: *mut WINHTTP_PROXY_RESULT_ENTRY,
    pub hProxyDetectionHandle: super::super::Foundation::HANDLE,
    pub dwProxyInterfaceAffinity: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for WINHTTP_PROXY_RESULT_EX {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for WINHTTP_PROXY_RESULT_EX {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for WINHTTP_PROXY_RESULT_EX {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("WINHTTP_PROXY_RESULT_EX").field("cEntries", &self.cEntries).field("pEntries", &self.pEntries).field("hProxyDetectionHandle", &self.hProxyDetectionHandle).field("dwProxyInterfaceAffinity", &self.dwProxyInterfaceAffinity).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for WINHTTP_PROXY_RESULT_EX {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for WINHTTP_PROXY_RESULT_EX {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<WINHTTP_PROXY_RESULT_EX>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for WINHTTP_PROXY_RESULT_EX {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for WINHTTP_PROXY_RESULT_EX {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct WINHTTP_PROXY_SETTINGS {
    pub dwStructSize: u32,
    pub dwFlags: u32,
    pub dwCurrentSettingsVersion: u32,
    pub pwszConnectionName: ::windows::core::PWSTR,
    pub pwszProxy: ::windows::core::PWSTR,
    pub pwszProxyBypass: ::windows::core::PWSTR,
    pub pwszAutoconfigUrl: ::windows::core::PWSTR,
    pub pwszAutoconfigSecondaryUrl: ::windows::core::PWSTR,
    pub dwAutoDiscoveryFlags: u32,
    pub pwszLastKnownGoodAutoConfigUrl: ::windows::core::PWSTR,
    pub dwAutoconfigReloadDelayMins: u32,
    pub ftLastKnownDetectTime: super::super::Foundation::FILETIME,
    pub dwDetectedInterfaceIpCount: u32,
    pub pdwDetectedInterfaceIp: *mut u32,
    pub cNetworkKeys: u32,
    pub pNetworkKeys: *mut WINHTTP_PROXY_NETWORKING_KEY,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for WINHTTP_PROXY_SETTINGS {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for WINHTTP_PROXY_SETTINGS {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for WINHTTP_PROXY_SETTINGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("WINHTTP_PROXY_SETTINGS")
            .field("dwStructSize", &self.dwStructSize)
            .field("dwFlags", &self.dwFlags)
            .field("dwCurrentSettingsVersion", &self.dwCurrentSettingsVersion)
            .field("pwszConnectionName", &self.pwszConnectionName)
            .field("pwszProxy", &self.pwszProxy)
            .field("pwszProxyBypass", &self.pwszProxyBypass)
            .field("pwszAutoconfigUrl", &self.pwszAutoconfigUrl)
            .field("pwszAutoconfigSecondaryUrl", &self.pwszAutoconfigSecondaryUrl)
            .field("dwAutoDiscoveryFlags", &self.dwAutoDiscoveryFlags)
            .field("pwszLastKnownGoodAutoConfigUrl", &self.pwszLastKnownGoodAutoConfigUrl)
            .field("dwAutoconfigReloadDelayMins", &self.dwAutoconfigReloadDelayMins)
            .field("ftLastKnownDetectTime", &self.ftLastKnownDetectTime)
            .field("dwDetectedInterfaceIpCount", &self.dwDetectedInterfaceIpCount)
            .field("pdwDetectedInterfaceIp", &self.pdwDetectedInterfaceIp)
            .field("cNetworkKeys", &self.cNetworkKeys)
            .field("pNetworkKeys", &self.pNetworkKeys)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for WINHTTP_PROXY_SETTINGS {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for WINHTTP_PROXY_SETTINGS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<WINHTTP_PROXY_SETTINGS>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for WINHTTP_PROXY_SETTINGS {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for WINHTTP_PROXY_SETTINGS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub struct WINHTTP_QUERY_CONNECTION_GROUP_RESULT {
    pub cHosts: u32,
    pub pHostConnectionGroups: *mut WINHTTP_HOST_CONNECTION_GROUP,
}
impl ::core::marker::Copy for WINHTTP_QUERY_CONNECTION_GROUP_RESULT {}
impl ::core::clone::Clone for WINHTTP_QUERY_CONNECTION_GROUP_RESULT {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for WINHTTP_QUERY_CONNECTION_GROUP_RESULT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("WINHTTP_QUERY_CONNECTION_GROUP_RESULT").field("cHosts", &self.cHosts).field("pHostConnectionGroups", &self.pHostConnectionGroups).finish()
    }
}
unsafe impl ::windows::core::Abi for WINHTTP_QUERY_CONNECTION_GROUP_RESULT {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for WINHTTP_QUERY_CONNECTION_GROUP_RESULT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<WINHTTP_QUERY_CONNECTION_GROUP_RESULT>()) == 0 }
    }
}
impl ::core::cmp::Eq for WINHTTP_QUERY_CONNECTION_GROUP_RESULT {}
impl ::core::default::Default for WINHTTP_QUERY_CONNECTION_GROUP_RESULT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
pub struct WINHTTP_REQUEST_STATS {
    pub ullFlags: u64,
    pub ulIndex: u32,
    pub cStats: u32,
    pub rgullStats: [u64; 32],
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::marker::Copy for WINHTTP_REQUEST_STATS {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::clone::Clone for WINHTTP_REQUEST_STATS {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
unsafe impl ::windows::core::Abi for WINHTTP_REQUEST_STATS {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::PartialEq for WINHTTP_REQUEST_STATS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<WINHTTP_REQUEST_STATS>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::Eq for WINHTTP_REQUEST_STATS {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::default::Default for WINHTTP_REQUEST_STATS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(4))]
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
#[cfg(target_arch = "x86")]
pub struct WINHTTP_REQUEST_STATS {
    pub ullFlags: u64,
    pub ulIndex: u32,
    pub cStats: u32,
    pub rgullStats: [u64; 32],
}
#[cfg(target_arch = "x86")]
impl ::core::marker::Copy for WINHTTP_REQUEST_STATS {}
#[cfg(target_arch = "x86")]
impl ::core::clone::Clone for WINHTTP_REQUEST_STATS {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
unsafe impl ::windows::core::Abi for WINHTTP_REQUEST_STATS {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::PartialEq for WINHTTP_REQUEST_STATS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<WINHTTP_REQUEST_STATS>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::Eq for WINHTTP_REQUEST_STATS {}
#[cfg(target_arch = "x86")]
impl ::core::default::Default for WINHTTP_REQUEST_STATS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
pub struct WINHTTP_REQUEST_TIMES {
    pub cTimes: u32,
    pub rgullTimes: [u64; 64],
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::marker::Copy for WINHTTP_REQUEST_TIMES {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::clone::Clone for WINHTTP_REQUEST_TIMES {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
unsafe impl ::windows::core::Abi for WINHTTP_REQUEST_TIMES {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::PartialEq for WINHTTP_REQUEST_TIMES {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<WINHTTP_REQUEST_TIMES>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::Eq for WINHTTP_REQUEST_TIMES {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::default::Default for WINHTTP_REQUEST_TIMES {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(4))]
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
#[cfg(target_arch = "x86")]
pub struct WINHTTP_REQUEST_TIMES {
    pub cTimes: u32,
    pub rgullTimes: [u64; 64],
}
#[cfg(target_arch = "x86")]
impl ::core::marker::Copy for WINHTTP_REQUEST_TIMES {}
#[cfg(target_arch = "x86")]
impl ::core::clone::Clone for WINHTTP_REQUEST_TIMES {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
unsafe impl ::windows::core::Abi for WINHTTP_REQUEST_TIMES {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::PartialEq for WINHTTP_REQUEST_TIMES {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<WINHTTP_REQUEST_TIMES>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::Eq for WINHTTP_REQUEST_TIMES {}
#[cfg(target_arch = "x86")]
impl ::core::default::Default for WINHTTP_REQUEST_TIMES {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
pub struct WINHTTP_RESOLVER_CACHE_CONFIG {
    pub ulMaxResolverCacheEntries: u32,
    pub ulMaxCacheEntryAge: u32,
    pub ulMinCacheEntryTtl: u32,
    pub SecureDnsSetting: WINHTTP_SECURE_DNS_SETTING,
    pub ullConnResolutionWaitTime: u64,
    pub ullFlags: u64,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::marker::Copy for WINHTTP_RESOLVER_CACHE_CONFIG {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::clone::Clone for WINHTTP_RESOLVER_CACHE_CONFIG {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
unsafe impl ::windows::core::Abi for WINHTTP_RESOLVER_CACHE_CONFIG {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::PartialEq for WINHTTP_RESOLVER_CACHE_CONFIG {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<WINHTTP_RESOLVER_CACHE_CONFIG>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::cmp::Eq for WINHTTP_RESOLVER_CACHE_CONFIG {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
impl ::core::default::Default for WINHTTP_RESOLVER_CACHE_CONFIG {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(4))]
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
#[cfg(target_arch = "x86")]
pub struct WINHTTP_RESOLVER_CACHE_CONFIG {
    pub ulMaxResolverCacheEntries: u32,
    pub ulMaxCacheEntryAge: u32,
    pub ulMinCacheEntryTtl: u32,
    pub SecureDnsSetting: WINHTTP_SECURE_DNS_SETTING,
    pub ullConnResolutionWaitTime: u64,
    pub ullFlags: u64,
}
#[cfg(target_arch = "x86")]
impl ::core::marker::Copy for WINHTTP_RESOLVER_CACHE_CONFIG {}
#[cfg(target_arch = "x86")]
impl ::core::clone::Clone for WINHTTP_RESOLVER_CACHE_CONFIG {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
unsafe impl ::windows::core::Abi for WINHTTP_RESOLVER_CACHE_CONFIG {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::PartialEq for WINHTTP_RESOLVER_CACHE_CONFIG {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<WINHTTP_RESOLVER_CACHE_CONFIG>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
impl ::core::cmp::Eq for WINHTTP_RESOLVER_CACHE_CONFIG {}
#[cfg(target_arch = "x86")]
impl ::core::default::Default for WINHTTP_RESOLVER_CACHE_CONFIG {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub struct WINHTTP_WEB_SOCKET_ASYNC_RESULT {
    pub AsyncResult: WINHTTP_ASYNC_RESULT,
    pub Operation: WINHTTP_WEB_SOCKET_OPERATION,
}
impl ::core::marker::Copy for WINHTTP_WEB_SOCKET_ASYNC_RESULT {}
impl ::core::clone::Clone for WINHTTP_WEB_SOCKET_ASYNC_RESULT {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for WINHTTP_WEB_SOCKET_ASYNC_RESULT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("WINHTTP_WEB_SOCKET_ASYNC_RESULT").field("AsyncResult", &self.AsyncResult).field("Operation", &self.Operation).finish()
    }
}
unsafe impl ::windows::core::Abi for WINHTTP_WEB_SOCKET_ASYNC_RESULT {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for WINHTTP_WEB_SOCKET_ASYNC_RESULT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<WINHTTP_WEB_SOCKET_ASYNC_RESULT>()) == 0 }
    }
}
impl ::core::cmp::Eq for WINHTTP_WEB_SOCKET_ASYNC_RESULT {}
impl ::core::default::Default for WINHTTP_WEB_SOCKET_ASYNC_RESULT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub struct WINHTTP_WEB_SOCKET_STATUS {
    pub dwBytesTransferred: u32,
    pub eBufferType: WINHTTP_WEB_SOCKET_BUFFER_TYPE,
}
impl ::core::marker::Copy for WINHTTP_WEB_SOCKET_STATUS {}
impl ::core::clone::Clone for WINHTTP_WEB_SOCKET_STATUS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for WINHTTP_WEB_SOCKET_STATUS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("WINHTTP_WEB_SOCKET_STATUS").field("dwBytesTransferred", &self.dwBytesTransferred).field("eBufferType", &self.eBufferType).finish()
    }
}
unsafe impl ::windows::core::Abi for WINHTTP_WEB_SOCKET_STATUS {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for WINHTTP_WEB_SOCKET_STATUS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<WINHTTP_WEB_SOCKET_STATUS>()) == 0 }
    }
}
impl ::core::cmp::Eq for WINHTTP_WEB_SOCKET_STATUS {}
impl ::core::default::Default for WINHTTP_WEB_SOCKET_STATUS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: `\"Win32_Networking_WinHttp\"`*"]
pub type WINHTTP_STATUS_CALLBACK = ::core::option::Option<unsafe extern "system" fn(hinternet: *mut ::core::ffi::c_void, dwcontext: usize, dwinternetstatus: u32, lpvstatusinformation: *mut ::core::ffi::c_void, dwstatusinformationlength: u32)>;
#[cfg(feature = "implement")]
::core::include!("impl.rs");
