/*
 * Copyright (c) 2005, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package sun.net.www.protocol.http;
import java.io.IOException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Arrays;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

/**
 * @since 1.6
 */
public class NegotiateCallbackHandler implements CallbackHandler {

    private String username;
    private char[] password;

    public void handle(Callback[] callbacks) throws
            UnsupportedCallbackException, IOException {
        for (int i=0; i<callbacks.length; i++) {
            Callback callBack = callbacks[i];

            if (callBack instanceof NameCallback) {
                if (username == null) {
                    PasswordAuthentication passAuth =
                            Authenticator.requestPasswordAuthentication(
                            null, null, 0, null,
                            null, "Negotiate");
                    username = passAuth.getUserName();
                    password = passAuth.getPassword();
                }
                NameCallback nameCallback =
                        (NameCallback)callBack;
                nameCallback.setName(username);

            } else if (callBack instanceof PasswordCallback) {
                PasswordCallback passwordCallback =
                        (PasswordCallback)callBack;
                if (password == null) {
                    PasswordAuthentication passAuth =
                            Authenticator.requestPasswordAuthentication(
                            null, null, 0, null,
                            null, "Negotiate");
                    username = passAuth.getUserName();
                    password = passAuth.getPassword();
                }
                passwordCallback.setPassword(password);
                Arrays.fill(password, ' ');
            } else {
                throw new UnsupportedCallbackException(callBack,
                        "Call back not supported");
            }//else
        }//for
    }
}
