/*
 * Copyright (c) 2018, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */


/*
 * @test
 *
 * @summary converted from VM Testbase nsk/jdi/BreakpointEvent/_itself_/breakpoint002.
 * VM Testbase keywords: [jpda, jdi]
 * VM Testbase readme:
 * DESCRIPTION
 *     The test checks up on the JDI interface
 *     com.sun.jdi.event.BreakpointEvent.
 *     A debugger part of the test creates several BreakpointRequests, and then it
 *     verifies that appropriate events are generated by the target VM.
 *     After that the debugger removes the requests by
 *     deleteAllBreakpoints() call. Finally, the test checks that the
 *     events corresponding to the deleted requests, are not generated
 *     by the target VM any more.
 * COMMENTS
 *     The test was updated due to the bug 4455653.
 *     ---------------------------------------------
 *     To fix the RFE 4615225, the test suite was moved here.
 *     Test updated to prevent possible VMDisconnectedException on VMDeathEvent:
 *     - quit on VMDeathEvent added to events handling loop
 *     Fixed according to 6290118 bug.
 *
 * @library /vmTestbase
 *          /test/lib
 * @build nsk.jdi.BreakpointEvent._itself_.breakpoint002
 *        nsk.jdi.BreakpointEvent._itself_.breakpoint002t
 *
 * @comment make sure breakpoint002t is compiled with full debug info
 * @clean nsk.jdi.BreakpointEvent._itself_.breakpoint002t
 * @compile -g:lines,source,vars ../breakpoint002t.java
 *
 * @run main/othervm
 *      nsk.jdi.BreakpointEvent._itself_.breakpoint002
 *      -verbose
 *      -arch=${os.family}-${os.simpleArch}
 *      -waittime=5
 *      -debugee.vmkind=java
 *      -transport.address=dynamic
 *      -debugee.vmkeys="${test.vm.opts} ${test.java.opts}"
 */

