# Maintainer tools

Useful tools used in daily routines:
- [checkpatch](https://docs.kernel.org/dev-tools/checkpatch.html)
- [kup](https://korg.docs.kernel.org/kup.html)
- [Auto-publishing](https://korg.docs.kernel.org/kup.html#auto-publishing-with-git-archive-signer)
- [b4](https://b4.docs.kernel.org/en/latest/)

# Checklist before applying patch

We don't have CI testing yet, so all those steps must be performed manually:
- Style check with [checkpatch](https://docs.kernel.org/dev-tools/checkpatch.html):

  This is the current code style follows. We are not strict to all rules. It must be run
  by **checkpatch --no-tree**, see README.md.

- [Commit style](https://www.kernel.org/doc/html/v4.10/process/submitting-patches.html):

  It doesn't need to be followed as strictly as is in kernel but changes should be logically
  separated. Submitter should care at least to mention "It is used in next patches" if unused
  externs/files are added in patch. We love: *Reported-by:*, *Suggested-by:*, *Fixes:* tags.

- Compilation, ideally on various gcc versions.
- Mdadm test suite execution.
- Consider requesting new tests from submitter, especially for new functionalities.
- Ensure that maintainer *sign-off* is added, before pushing.

# Making a release

Assuming that maintainer is certain that release is safe, following steps must be done:

- Update versions strings in release commit, please refer to previous releases for examples.

- Create GPG signed tag and push it to repo. Use same format as was used previously, prefixed by
  **mdadm-**, e.g. **mdadm-3.1.2**, **mdadm-4.1**.

- [Auto-publishing](https://korg.docs.kernel.org/kup.html#auto-publishing-with-git-archive-signer):

  Adopt script to our release tag model. When ready, push signed note to repository. If it is done
  correctly, then *(sig)* is added to the package automatically generated by kernel.org automation.
  There is no need to upload archive manually.

- Update CHANGELOG.md.
- Write "ANNOUNCE" mail to linux-raid@kernel.org to notify community.
