/*
 * Decompiled with CFR 0.152.
 */
package org.xmlopen.zipspy;

import java.io.FileInputStream;
import java.text.MessageFormat;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;
import org.xmlopen.zipspy.ZipArchive;

public class Driver {
    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                System.err.println("arguments: path/to/the/file/to/test.zip");
                System.exit(1);
            }
            FileInputStream is = new FileInputStream(args[0]);
            ZipArchive archive = new ZipArchive(is);
            int crCount = archive.getCentralRecordCount();
            int lhCount = archive.getLocalHeaderCount();
            System.out.println(MessageFormat.format("crCount: {0}, lhCount: {1}", crCount, lhCount));
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    static {
        String logLvl = System.getProperty("property://probatron.org/officeotron-log-level");
        logLvl = logLvl == null ? "DEBUG" : logLvl;
        Properties p = new Properties();
        p.setProperty("log4j.rootCategory", logLvl + ", A1");
        p.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        p.setProperty("log4j.appender.A1.target", "System.err");
        p.setProperty("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
        p.setProperty("log4j.appender.A1.layout.ConversionPattern", "%c %p - %m%n");
        PropertyConfigurator.configure(p);
    }
}

