# libgphoto2

Hello and welcome to the wonderful world of gphoto! This is libgphoto2, the
successor of gphoto with lots of new features and additional camera
drivers.

If you miss a feature, would like to report success or failure, or have any
questions, please don't hesitate to contact our mailing list.


## What is libgphoto2?

libgphoto2 is a library that can be used by applications to access various
digital cameras.  

For more information on gphoto, see [gphoto project home page].

There, you can also get information on mailing lists, supported cameras,
and availability of gphoto2. Another source of information is [gphoto github project page].

where you can access our SVN server to fetch the source code of
gphoto2, gtkam and GnoCam (see below).


## What is libgphoto2 not?

libgphoto2 itself is not a GUI application, opposed to gphoto. There are
GUI frontends for the gphoto2 library, however, such as gtkam for
example.

libgphoto2 can only talk to cameras the language of those it understands.
That is, if you own a camera that speaks a language that isn't published
anywhere and nobody has been able to figure out the meaning of the sentences,
libgphoto2 cannot communicate with those cameras.

Then, there are cameras supporting the so-called USB Mass Storage protocol.
This is a protocol that has been published and lets you access any storage
device, be it a camera or a disk connected via USB to your computer. As there
are already drivers for this protocol out there, you don't need an additional
library like libgphoto2. The list of camera that use USB Mass Storage is getting
longer everyday, so we won't publish it.

For a more up to date list, you can consult [camera list with support status].

Your operating system will tell you about that because it is likely to recognize
the device as a SCSI disk that you can mount (for Linux 'dmesg' will tell you).
Again, those cameras *cannot* be accessed through libgphoto2. Some of them can
be switched to use a different communication protocol and might be in that case
useable with libgphoto2.

Other camera support a protocol called PTP or USB Imaging Devices that has
been developed by Kodak and other. libgphoto2 does support PTP. Also working
will be cameras labeled as "PictBridge", which is a extension to PTP.

Almost all cameras that are not mass storage support it these days, including
but not limited to all Nikon, Canon, Fuji, Sony, Panasonic, HP and more.

PTP camera unknown to libgphoto2 will be detected as a generic PTP camera and
will work as-is without any changes.

MTP (Microsoft Transfer Protocol) capable devices will also be accessible,
since MTP is based on PTP.


## Platforms

libgphoto2 should compile and run on pretty much all Unix-like platforms.
libgphoto2 has _not_ (yet?) been ported to any operating system from MicroSoft.


## Bindings

- Java: [gphoto2-java](https://github.com/mvysny/gphoto2-java), [libgphoto2-jna](https://github.com/angryelectron/libgphoto2-jna)
- Python: [python-gphoto2](https://github.com/jim-easterbrook/python-gphoto2), [gphoto2-cffi](https://github.com/jbaiter/gphoto2-cffi)
- C#: [libgphoto2-sharp](https://github.com/gphoto/libgphoto2-sharp)
- Go: [go-gphoto2](https://github.com/aqiank/go-gphoto2)
- Rust: [gphoto-rs](https://github.com/dcuddeback/gphoto-rs)
- Node.js: [node-gphoto2](https://github.com/lwille/node-gphoto2)
- Ruby: [ffi-gphoto2](https://github.com/zaeleus/ffi-gphoto2)
- Crystal: [gphoto2.cr](https://github.com/sija/gphoto2.cr)


## How to set up libgphoto2

For information on how to set up libgphoto2 and its frontends, see
The gphoto2 Manual.

It is available at the following places:

 - At the gphoto website: [gphoto project home page]
 - In the SVN module gphoto2-manual

The gphoto2 Manual includes information about setting up USB
hotplugging.

If you run into problems, you may also consult the FAQ (also included
in The gphoto2 Manual).


## Frontends

gphoto2 is a command line frontend which is quite powerful,
especially in combination with scripts. See The gphoto2 Manual
for a short description.

For the GUI lovers, there are for example digikam (KDE), gthumb (GNOME),
f-spot (GNOME / Mono) and more. We also have a GTK2 reference GUI
called gtkam, which is unmaintained, its only special features are
capture ability.
Additionally, there are plugins for other programs available like
kio_camera (KDE - Konqueror) and a fuse plugin, gphotofs.


## Reporting Bugs

Every piece of software contains errors and flaws. So does
libgphoto2. When you encounter something that does not work, please do
the following:

1. Find out whether this is a known problem.

2. Reproduce the problem with debug output enabled and the language
    set to English, so that the development team will understand the
    messages. You can do this by running:

        env LC_ALL=C gtkam

    if you're using the gtkam frontend or running:

        env LC_ALL=C gphoto2 --debug-logfile=logfile.log --debug <options>

    using the gphoto2 command line interface.

3. Report the problem on the mailing list with the corresponding debug
    output if it is small. If it is more than a few kilobytes, please
    don't post the complete debug output on the list.


[gphoto project home page]: http://www.gphoto.org/
[gphoto github project page]: https://github.com/gphoto
[camera list with support status]: http://www.teaser.fr/~hfiguiere/linux/digicam.html
[jphoto home page]: http://jphoto.sourceforge.net/
[information about using USB mass storage]: http://www.linux-usb.org/USB-guide/x498.html
[gphoto development mailing list]: gphoto-devel@lists.sourceforge.net
[gphoto user mailing list]: gphoto-user@lists.sourceforge.net
[gphoto translation mailing list]: gphoto-translation@lists.sourceforge.net
