package mobileengagement

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"net/http"
)

// ExportTasksClient is the microsoft Azure Mobile Engagement REST APIs.
type ExportTasksClient struct {
	ManagementClient
}

// NewExportTasksClient creates an instance of the ExportTasksClient client.
func NewExportTasksClient(subscriptionID string, resourceGroupName string, appCollection string, appName string) ExportTasksClient {
	return NewExportTasksClientWithBaseURI(DefaultBaseURI, subscriptionID, resourceGroupName, appCollection, appName)
}

// NewExportTasksClientWithBaseURI creates an instance of the
// ExportTasksClient client.
func NewExportTasksClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, appCollection string, appName string) ExportTasksClient {
	return ExportTasksClient{NewWithBaseURI(baseURI, subscriptionID, resourceGroupName, appCollection, appName)}
}

// CreateActivitiesTask creates a task to export activities.
//
func (client ExportTasksClient) CreateActivitiesTask(parameters DateRangeExportTaskParameter) (result ExportTaskResult, err error) {
	req, err := client.CreateActivitiesTaskPreparer(parameters)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateActivitiesTask", nil, "Failure preparing request")
	}

	resp, err := client.CreateActivitiesTaskSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateActivitiesTask", resp, "Failure sending request")
	}

	result, err = client.CreateActivitiesTaskResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateActivitiesTask", resp, "Failure responding to request")
	}

	return
}

// CreateActivitiesTaskPreparer prepares the CreateActivitiesTask request.
func (client ExportTasksClient) CreateActivitiesTaskPreparer(parameters DateRangeExportTaskParameter) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appCollection":     autorest.Encode("path", client.AppCollection),
		"appName":           autorest.Encode("path", client.AppName),
		"resourceGroupName": autorest.Encode("path", client.ResourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/devices/exportTasks/activities", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateActivitiesTaskSender sends the CreateActivitiesTask request. The method will close the
// http.Response Body if it receives an error.
func (client ExportTasksClient) CreateActivitiesTaskSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateActivitiesTaskResponder handles the response to the CreateActivitiesTask request. The method always
// closes the http.Response Body.
func (client ExportTasksClient) CreateActivitiesTaskResponder(resp *http.Response) (result ExportTaskResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateCrashesTask creates a task to export crashes.
//
func (client ExportTasksClient) CreateCrashesTask(parameters DateRangeExportTaskParameter) (result ExportTaskResult, err error) {
	req, err := client.CreateCrashesTaskPreparer(parameters)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateCrashesTask", nil, "Failure preparing request")
	}

	resp, err := client.CreateCrashesTaskSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateCrashesTask", resp, "Failure sending request")
	}

	result, err = client.CreateCrashesTaskResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateCrashesTask", resp, "Failure responding to request")
	}

	return
}

// CreateCrashesTaskPreparer prepares the CreateCrashesTask request.
func (client ExportTasksClient) CreateCrashesTaskPreparer(parameters DateRangeExportTaskParameter) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appCollection":     autorest.Encode("path", client.AppCollection),
		"appName":           autorest.Encode("path", client.AppName),
		"resourceGroupName": autorest.Encode("path", client.ResourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/devices/exportTasks/crashes", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateCrashesTaskSender sends the CreateCrashesTask request. The method will close the
// http.Response Body if it receives an error.
func (client ExportTasksClient) CreateCrashesTaskSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateCrashesTaskResponder handles the response to the CreateCrashesTask request. The method always
// closes the http.Response Body.
func (client ExportTasksClient) CreateCrashesTaskResponder(resp *http.Response) (result ExportTaskResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateErrorsTask creates a task to export errors.
//
func (client ExportTasksClient) CreateErrorsTask(parameters DateRangeExportTaskParameter) (result ExportTaskResult, err error) {
	req, err := client.CreateErrorsTaskPreparer(parameters)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateErrorsTask", nil, "Failure preparing request")
	}

	resp, err := client.CreateErrorsTaskSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateErrorsTask", resp, "Failure sending request")
	}

	result, err = client.CreateErrorsTaskResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateErrorsTask", resp, "Failure responding to request")
	}

	return
}

// CreateErrorsTaskPreparer prepares the CreateErrorsTask request.
func (client ExportTasksClient) CreateErrorsTaskPreparer(parameters DateRangeExportTaskParameter) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appCollection":     autorest.Encode("path", client.AppCollection),
		"appName":           autorest.Encode("path", client.AppName),
		"resourceGroupName": autorest.Encode("path", client.ResourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/devices/exportTasks/errors", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateErrorsTaskSender sends the CreateErrorsTask request. The method will close the
// http.Response Body if it receives an error.
func (client ExportTasksClient) CreateErrorsTaskSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateErrorsTaskResponder handles the response to the CreateErrorsTask request. The method always
// closes the http.Response Body.
func (client ExportTasksClient) CreateErrorsTaskResponder(resp *http.Response) (result ExportTaskResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateEventsTask creates a task to export events.
//
func (client ExportTasksClient) CreateEventsTask(parameters DateRangeExportTaskParameter) (result ExportTaskResult, err error) {
	req, err := client.CreateEventsTaskPreparer(parameters)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateEventsTask", nil, "Failure preparing request")
	}

	resp, err := client.CreateEventsTaskSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateEventsTask", resp, "Failure sending request")
	}

	result, err = client.CreateEventsTaskResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateEventsTask", resp, "Failure responding to request")
	}

	return
}

// CreateEventsTaskPreparer prepares the CreateEventsTask request.
func (client ExportTasksClient) CreateEventsTaskPreparer(parameters DateRangeExportTaskParameter) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appCollection":     autorest.Encode("path", client.AppCollection),
		"appName":           autorest.Encode("path", client.AppName),
		"resourceGroupName": autorest.Encode("path", client.ResourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/devices/exportTasks/events", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateEventsTaskSender sends the CreateEventsTask request. The method will close the
// http.Response Body if it receives an error.
func (client ExportTasksClient) CreateEventsTaskSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateEventsTaskResponder handles the response to the CreateEventsTask request. The method always
// closes the http.Response Body.
func (client ExportTasksClient) CreateEventsTaskResponder(resp *http.Response) (result ExportTaskResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateFeedbackTaskByCampaign creates a task to export push campaign data
// for a set of campaigns.
//
func (client ExportTasksClient) CreateFeedbackTaskByCampaign(parameters FeedbackByCampaignParameter) (result ExportTaskResult, err error) {
	req, err := client.CreateFeedbackTaskByCampaignPreparer(parameters)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateFeedbackTaskByCampaign", nil, "Failure preparing request")
	}

	resp, err := client.CreateFeedbackTaskByCampaignSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateFeedbackTaskByCampaign", resp, "Failure sending request")
	}

	result, err = client.CreateFeedbackTaskByCampaignResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateFeedbackTaskByCampaign", resp, "Failure responding to request")
	}

	return
}

// CreateFeedbackTaskByCampaignPreparer prepares the CreateFeedbackTaskByCampaign request.
func (client ExportTasksClient) CreateFeedbackTaskByCampaignPreparer(parameters FeedbackByCampaignParameter) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appCollection":     autorest.Encode("path", client.AppCollection),
		"appName":           autorest.Encode("path", client.AppName),
		"resourceGroupName": autorest.Encode("path", client.ResourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/devices/exportTasks/feedbackByCampaign", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateFeedbackTaskByCampaignSender sends the CreateFeedbackTaskByCampaign request. The method will close the
// http.Response Body if it receives an error.
func (client ExportTasksClient) CreateFeedbackTaskByCampaignSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateFeedbackTaskByCampaignResponder handles the response to the CreateFeedbackTaskByCampaign request. The method always
// closes the http.Response Body.
func (client ExportTasksClient) CreateFeedbackTaskByCampaignResponder(resp *http.Response) (result ExportTaskResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateFeedbackTaskByDateRange creates a task to export push campaign data
// for a date range.
//
func (client ExportTasksClient) CreateFeedbackTaskByDateRange(parameters FeedbackByDateRangeParameter) (result ExportTaskResult, err error) {
	req, err := client.CreateFeedbackTaskByDateRangePreparer(parameters)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateFeedbackTaskByDateRange", nil, "Failure preparing request")
	}

	resp, err := client.CreateFeedbackTaskByDateRangeSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateFeedbackTaskByDateRange", resp, "Failure sending request")
	}

	result, err = client.CreateFeedbackTaskByDateRangeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateFeedbackTaskByDateRange", resp, "Failure responding to request")
	}

	return
}

// CreateFeedbackTaskByDateRangePreparer prepares the CreateFeedbackTaskByDateRange request.
func (client ExportTasksClient) CreateFeedbackTaskByDateRangePreparer(parameters FeedbackByDateRangeParameter) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appCollection":     autorest.Encode("path", client.AppCollection),
		"appName":           autorest.Encode("path", client.AppName),
		"resourceGroupName": autorest.Encode("path", client.ResourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/devices/exportTasks/feedbackByDate", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateFeedbackTaskByDateRangeSender sends the CreateFeedbackTaskByDateRange request. The method will close the
// http.Response Body if it receives an error.
func (client ExportTasksClient) CreateFeedbackTaskByDateRangeSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateFeedbackTaskByDateRangeResponder handles the response to the CreateFeedbackTaskByDateRange request. The method always
// closes the http.Response Body.
func (client ExportTasksClient) CreateFeedbackTaskByDateRangeResponder(resp *http.Response) (result ExportTaskResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateJobsTask creates a task to export jobs.
//
func (client ExportTasksClient) CreateJobsTask(parameters DateRangeExportTaskParameter) (result ExportTaskResult, err error) {
	req, err := client.CreateJobsTaskPreparer(parameters)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateJobsTask", nil, "Failure preparing request")
	}

	resp, err := client.CreateJobsTaskSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateJobsTask", resp, "Failure sending request")
	}

	result, err = client.CreateJobsTaskResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateJobsTask", resp, "Failure responding to request")
	}

	return
}

// CreateJobsTaskPreparer prepares the CreateJobsTask request.
func (client ExportTasksClient) CreateJobsTaskPreparer(parameters DateRangeExportTaskParameter) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appCollection":     autorest.Encode("path", client.AppCollection),
		"appName":           autorest.Encode("path", client.AppName),
		"resourceGroupName": autorest.Encode("path", client.ResourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/devices/exportTasks/jobs", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateJobsTaskSender sends the CreateJobsTask request. The method will close the
// http.Response Body if it receives an error.
func (client ExportTasksClient) CreateJobsTaskSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateJobsTaskResponder handles the response to the CreateJobsTask request. The method always
// closes the http.Response Body.
func (client ExportTasksClient) CreateJobsTaskResponder(resp *http.Response) (result ExportTaskResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateSessionsTask creates a task to export sessions.
//
func (client ExportTasksClient) CreateSessionsTask(parameters DateRangeExportTaskParameter) (result ExportTaskResult, err error) {
	req, err := client.CreateSessionsTaskPreparer(parameters)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateSessionsTask", nil, "Failure preparing request")
	}

	resp, err := client.CreateSessionsTaskSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateSessionsTask", resp, "Failure sending request")
	}

	result, err = client.CreateSessionsTaskResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateSessionsTask", resp, "Failure responding to request")
	}

	return
}

// CreateSessionsTaskPreparer prepares the CreateSessionsTask request.
func (client ExportTasksClient) CreateSessionsTaskPreparer(parameters DateRangeExportTaskParameter) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appCollection":     autorest.Encode("path", client.AppCollection),
		"appName":           autorest.Encode("path", client.AppName),
		"resourceGroupName": autorest.Encode("path", client.ResourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/devices/exportTasks/sessions", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateSessionsTaskSender sends the CreateSessionsTask request. The method will close the
// http.Response Body if it receives an error.
func (client ExportTasksClient) CreateSessionsTaskSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateSessionsTaskResponder handles the response to the CreateSessionsTask request. The method always
// closes the http.Response Body.
func (client ExportTasksClient) CreateSessionsTaskResponder(resp *http.Response) (result ExportTaskResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateTagsTask creates a task to export tags.
//
func (client ExportTasksClient) CreateTagsTask(parameters ExportTaskParameter) (result ExportTaskResult, err error) {
	req, err := client.CreateTagsTaskPreparer(parameters)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateTagsTask", nil, "Failure preparing request")
	}

	resp, err := client.CreateTagsTaskSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateTagsTask", resp, "Failure sending request")
	}

	result, err = client.CreateTagsTaskResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateTagsTask", resp, "Failure responding to request")
	}

	return
}

// CreateTagsTaskPreparer prepares the CreateTagsTask request.
func (client ExportTasksClient) CreateTagsTaskPreparer(parameters ExportTaskParameter) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appCollection":     autorest.Encode("path", client.AppCollection),
		"appName":           autorest.Encode("path", client.AppName),
		"resourceGroupName": autorest.Encode("path", client.ResourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/devices/exportTasks/tags", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateTagsTaskSender sends the CreateTagsTask request. The method will close the
// http.Response Body if it receives an error.
func (client ExportTasksClient) CreateTagsTaskSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateTagsTaskResponder handles the response to the CreateTagsTask request. The method always
// closes the http.Response Body.
func (client ExportTasksClient) CreateTagsTaskResponder(resp *http.Response) (result ExportTaskResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateTokensTask creates a task to export tags.
//
func (client ExportTasksClient) CreateTokensTask(parameters ExportTaskParameter) (result ExportTaskResult, err error) {
	req, err := client.CreateTokensTaskPreparer(parameters)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateTokensTask", nil, "Failure preparing request")
	}

	resp, err := client.CreateTokensTaskSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateTokensTask", resp, "Failure sending request")
	}

	result, err = client.CreateTokensTaskResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "CreateTokensTask", resp, "Failure responding to request")
	}

	return
}

// CreateTokensTaskPreparer prepares the CreateTokensTask request.
func (client ExportTasksClient) CreateTokensTaskPreparer(parameters ExportTaskParameter) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appCollection":     autorest.Encode("path", client.AppCollection),
		"appName":           autorest.Encode("path", client.AppName),
		"resourceGroupName": autorest.Encode("path", client.ResourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/devices/exportTasks/tokens", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateTokensTaskSender sends the CreateTokensTask request. The method will close the
// http.Response Body if it receives an error.
func (client ExportTasksClient) CreateTokensTaskSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateTokensTaskResponder handles the response to the CreateTokensTask request. The method always
// closes the http.Response Body.
func (client ExportTasksClient) CreateTokensTaskResponder(resp *http.Response) (result ExportTaskResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Get retrieves information about a previously created export task.
//
// id is export task identifier.
func (client ExportTasksClient) Get(id string) (result ExportTaskResult, err error) {
	req, err := client.GetPreparer(id)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "Get", nil, "Failure preparing request")
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "Get", resp, "Failure sending request")
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client ExportTasksClient) GetPreparer(id string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appCollection":     autorest.Encode("path", client.AppCollection),
		"appName":           autorest.Encode("path", client.AppName),
		"id":                autorest.Encode("path", id),
		"resourceGroupName": autorest.Encode("path", client.ResourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/devices/exportTasks/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client ExportTasksClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client ExportTasksClient) GetResponder(resp *http.Response) (result ExportTaskResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List get the list of export tasks.
//
// skip is control paging of export tasks, start results at the given offset,
// defaults to 0 (1st page of data). top is control paging of export tasks,
// number of export tasks to return with each call. By default, it returns
// all export tasks with a default paging of 20.
// The response contains a `nextLink` property describing the path to get the
// next page if there are more results.
// The maximum paging limit for $top is 40. orderby is sort results by an
// expression which looks like `$orderby=taskId asc` (default when not
// specified).
// The syntax is orderby={property} {direction} or just orderby={property}.
// Properties that can be specified for sorting: taskId, errorDetails,
// dateCreated, taskStatus, and dateCreated.
// The available directions are asc (for ascending order) and desc (for
// descending order).
// When not specified the asc direction is used.
// Only one orderby property can be specified.
func (client ExportTasksClient) List(skip *int32, top *int32, orderby string) (result ExportTaskListResult, err error) {
	req, err := client.ListPreparer(skip, top, orderby)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "List", nil, "Failure preparing request")
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "List", resp, "Failure sending request")
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client ExportTasksClient) ListPreparer(skip *int32, top *int32, orderby string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appCollection":     autorest.Encode("path", client.AppCollection),
		"appName":           autorest.Encode("path", client.AppName),
		"resourceGroupName": autorest.Encode("path", client.ResourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}
	if skip != nil {
		queryParameters["$skip"] = autorest.Encode("query", *skip)
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if len(orderby) > 0 {
		queryParameters["$orderby"] = autorest.Encode("query", orderby)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/devices/exportTasks", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client ExportTasksClient) ListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client ExportTasksClient) ListResponder(resp *http.Response) (result ExportTaskListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListNextResults retrieves the next set of results, if any.
func (client ExportTasksClient) ListNextResults(lastResults ExportTaskListResult) (result ExportTaskListResult, err error) {
	req, err := lastResults.ExportTaskListResultPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "List", nil, "Failure preparing next results request request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "List", resp, "Failure sending next results request request")
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.ExportTasksClient", "List", resp, "Failure responding to next results request request")
	}

	return
}
