/*
 * Copyright (C) 2017 Red Hat, Inc.
 *
 * Author: Nikos Mavrogiannopoulos
 *
 * This file is part of GnuTLS.
 *
 * GnuTLS is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * GnuTLS is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GnuTLS.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <gnutls/gnutls.h>

#include "utils.h"

#define ALGO_MATCHES(sig, pk, val)                                            \
	ret = gnutls_sign_supports_pk_algorithm(sig, pk);                     \
	if (ret != val) {                                                     \
		fail("error testing %s with %s\n", gnutls_sign_get_name(sig), \
		     gnutls_pk_get_name(pk));                                 \
	}

void doit(void)
{
	int ret;

	ALGO_MATCHES(GNUTLS_SIGN_RSA_SHA1, GNUTLS_PK_RSA, 1);
	ALGO_MATCHES(GNUTLS_SIGN_RSA_SHA256, GNUTLS_PK_RSA, 1);
	ALGO_MATCHES(GNUTLS_SIGN_RSA_SHA384, GNUTLS_PK_RSA, 1);
	ALGO_MATCHES(GNUTLS_SIGN_RSA_SHA512, GNUTLS_PK_RSA, 1);
	ALGO_MATCHES(GNUTLS_SIGN_RSA_SHA3_256, GNUTLS_PK_RSA, 1);
	ALGO_MATCHES(GNUTLS_SIGN_RSA_SHA3_384, GNUTLS_PK_RSA, 1);
	ALGO_MATCHES(GNUTLS_SIGN_RSA_SHA3_512, GNUTLS_PK_RSA, 1);

	/* TLS 1.3 allows RSA-PSS signatures to be generated by RSA keys */
	ALGO_MATCHES(GNUTLS_SIGN_RSA_SHA256, GNUTLS_PK_RSA, 1);
	ALGO_MATCHES(GNUTLS_SIGN_RSA_SHA384, GNUTLS_PK_RSA, 1);
	ALGO_MATCHES(GNUTLS_SIGN_RSA_SHA512, GNUTLS_PK_RSA, 1);

	ALGO_MATCHES(GNUTLS_SIGN_RSA_PSS_SHA256, GNUTLS_PK_RSA_PSS, 1);
	ALGO_MATCHES(GNUTLS_SIGN_RSA_PSS_SHA384, GNUTLS_PK_RSA_PSS, 1);
	ALGO_MATCHES(GNUTLS_SIGN_RSA_PSS_SHA512, GNUTLS_PK_RSA_PSS, 1);

	/* rsa-pss keys shouldn't generate plain signatures */
	ALGO_MATCHES(GNUTLS_SIGN_RSA_SHA256, GNUTLS_PK_RSA_PSS, 0);
	ALGO_MATCHES(GNUTLS_SIGN_RSA_SHA384, GNUTLS_PK_RSA_PSS, 0);
	ALGO_MATCHES(GNUTLS_SIGN_RSA_SHA512, GNUTLS_PK_RSA_PSS, 0);
}
