# ADSys: Active Directory Group Policy integration

**ADSys** is the **Active Directory Group Policy client** for Ubuntu. It allows system administrators to manage and control Ubuntu Desktop clients from a central Microsoft Active Directory.
The project contains everything you need to integrate Ubuntu to your Active Directory, including **admx** and **adml** template files.

The role of **ADSys** is solely the configuration of the host via Active Directory. Authentication of the users, initial security policy of the `Default Domain Policy` and creation of the home directory is still the responsibility of SSSD/Winbind and PAM.
Once an Ubuntu client is configured, Active Directory Group Policies are applied on boot for the machine and at login time for each user, then refreshed periodically.

It is composed of 2 parts: a daemon and a client and a command line interface:

* The daemon - `adsysd` - implements the Group Policy protocol. It relies on Kerberos, Samba and LDAP for authentication and policy retrieval.
* The command line interface - `adsysctl` - controls the daemon and its status.

## Supported releases

**ADSys** is supported on Ubuntu starting from **20.04.2 LTS**, and tested with Windows Server 2019.

Only Active Directory on-prem is supported. Azure Active Directory (AAD) is not yet supported but on the roadmap (No ETA at the moment).

## Contributions are welcome!

ADSys licence is [GPL v3](https://github.com/ubuntu/adsys/blob/main/LICENSE).

The source code is available on [GitHub upstream repository](https://github.com/ubuntu/adsys). For non trivial changes, please [open a bug](https://github.com/ubuntu/adsys/issues/new) describing your intentions first so that we can discuss the best strategy.

If you ever find an issue, you can report it following our [project template](https://github.com/ubuntu/adsys/issues/new).

## Recommended readings

* `adsysd help` or `man adsysd`.
* `adsysctl help` or `man adsysctl`.
* This documentation is also [available online](https://github.com/ubuntu/adsys/wiki)
